/*****************************************************************************
* Function to window the plot
*****************************************************************************/

#include <stdio.h>
#include <cpgplot.h>
#include "iact.h"
#include "eltpsffit.h"

#define  ZF   0.8    /* Zoom factor */

void epf1dwindowing(icom *com, env1dim *env, data1dim *data) {

  int              imin, imax;
  float            help;
  int              sidxnval(float *, int, float);
  void             range(float *, int, float *, float *, int),
                   getcom(int, int, float, float, icom *);


  cpgsci(7);

  do {
    if (com->c[0] == 'w' || com->c[0] == '?')
      getcom(7, 0, com->x, com->y, com);
    
    if (com->c[0] == 'a' || com->c[0] == 'X') {
      range(data->fx, data->npts, &(env->xmin), &(env->xmax), 0);
      range(data->yd, data->npts, &(env->ymin), &(env->ymax), 0);

    } else if (com->c[0] == '/') {
      range(data->fx, data->npts, &(env->xmin), &(env->xmax), 0);

    } else if (com->c[0] == '=') {
      imin = sidxnval(data->fx, data->npts, env->xmin);
      imax = sidxnval(data->fx, data->npts, env->xmax);
      range(data->yd+imin, imax-imin, &(env->ymin), &(env->ymax), 0);
	
    } else if (com->c[0] == '|') {
      env->xmin = com->x;
      cpgband(4, 0, env->xmin, com->y, &(env->xmax), &(com->y), com->c);
      if (env->xmin > env->xmax) {
	help = env->xmin;
	env->xmin = env->xmax;
	env->xmax = help;
      }

    } else if (com->c[0] == '-') {
      env->ymin = com->y;
      cpgband(3, 0, com->x, env->ymin, &(com->x), &(env->ymax), com->c);
      if (env->ymin > env->ymax) {
	help = env->ymin;
	env->ymin = env->ymax;
	env->ymax = help;
      }

    } else if (com->c[0] == 'A' && com->drag) {
      env->xmin -= com->x - com->xp;
      env->xmax -= com->x - com->xp;
      env->ymin -= com->y - com->yp;
      env->ymax -= com->y - com->yp;
      
    } else if (com->c[0] == 'e' || com->c[0] == 'A') {
      env->xmin = com->x;
      env->ymin = com->y;
      cpgband(2, 0, com->x, com->y, &(env->xmax), &(env->ymax), com->c);
      if (env->xmin > env->xmax) {
	help = env->xmin;
	env->xmin = env->xmax;
	env->xmax = help;
      }
      if (env->ymin > env->ymax) {
	help = env->ymin;
	env->ymin = env->ymax;
	env->ymax = help;
      }
      
    } else if (com->c[0] == 'l') {
      if (com->x < env->xmax)
	env->xmin = com->x;

    } else if (com->c[0] == 'r') {
      if (com->x > env->xmin)
	env->xmax = com->x;

    } else if (com->c[0] == 'b') {
      if (com->y < env->ymax)
	env->ymin = com->y;

    } else if (com->c[0] == 't') {
      if (com->y > env->ymin)
	env->ymax = com->y;

    } else if (com->c[0] == 'c' || com->c[0] == 'D') {
      help = env->xmax - env->xmin;
      env->xmax = com->x + help / 2.0;
      env->xmin = com->x - help / 2.0;
      help = env->ymax - env->ymin;
      env->ymax = com->y + help / 2.0;
      env->ymin = com->y - help / 2.0;

    } else if (com->c[0] == 'q' || com->c[0] == 'Y') {
      env->xmax = com->x + ZF * (env->xmax - com->x);
      env->xmin = com->x - ZF * (com->x - env->xmin);
      env->ymax = com->y + ZF * (env->ymax - com->y);
      env->ymin = com->y - ZF * (com->y - env->ymin);

    } else if (com->c[0] == 'w' || com->c[0] == 'P') {
      env->xmax = com->x + 1.0/ZF * (env->xmax - com->x);
      env->xmin = com->x - 1.0/ZF * (com->x - env->xmin);
      env->ymax = com->y + 1.0/ZF * (env->ymax - com->y);
      env->ymin = com->y - 1.0/ZF * (com->y - env->ymin);

    } else if (com->c[0] == 's' || com->c[0]+64 == 'Y') {
      env->xmax = com->x + ZF * (env->xmax - com->x);
      env->xmin = com->x - ZF * (com->x - env->xmin);
      
    } else if (com->c[0] == 'd' || com->c[0]+64 == 'P') {
      env->xmax = com->x + 1.0/ZF * (env->xmax - com->x);
      env->xmin = com->x - 1.0/ZF * (com->x - env->xmin);

    } else if (com->c[0] == 'z' || com->c[0] == 'y') {
      env->ymax = com->y + ZF * (env->ymax - com->y);
      env->ymin = com->y - ZF * (com->y - env->ymin);

    } else if (com->c[0] == 'x' || com->c[0] == 'p') {
      env->ymax = com->y + 1.0/ZF * (env->ymax - com->y);
      env->ymin = com->y - 1.0/ZF * (com->y - env->ymin);      

    } else if (com->c[0] == 'u') {
      help = (env->ymax - env->ymin) / 6.0;
      env->ymax += help;
      env->ymin += help;

    } else if (com->c[0] == 'j') {
      help = (env->ymax - env->ymin) / 6.0;
      env->ymax -= help;
      env->ymin -= help;

    } else if (com->c[0] == 'k') {
      help = (env->xmax - env->xmin) / 6.0;
      env->xmax += help;
      env->xmin += help;

    } else if (com->c[0] == 'h') {
      help = (env->xmax - env->xmin) / 6.0;
      env->xmax -= help;
      env->xmin -= help;

    } else if (com->c[0] == '?') {
      fprintf(stderr, "\nList of windowing commands:\n\n");
      fprintf(stderr, "\t?\t\t\tprint this list\n \
\tlmb click'n'drag\tshift plot\n \
\te or lmb\t\tmagnify\n \
\tc or mmb\t\tcentre plot on cursor position\n \
\ta or rmb\t\trestore x and y limits\n \
\t/\t\t\trestore x limits\n \
\t=\t\t\tadjust y limits\n \
\tq/w or scroll\t\tzoom in and out\n \
\ts/d or Ctrl-scroll\tzoom x-axis\n \
\tz/x or Shift-scroll\tzoom y-axis\n \
\t|\t\t\tchoose x limits\n \
\t-\t\t\tchoose y limits\n \
\tl\t\t\tchoose xmin\n \
\tr\t\t\tchoose xmax\n \
\tb\t\t\tchoose ymin\n \
\tt\t\t\tchoose ymax\n \
\tu\n \
      h k\t\t\tscroll up, down, left, right\n \
\tj\n");
    }

  } while (com->c[0] == '?');

  cpgsci(1);
  return;
}
