/****************************************************************************
* Write out the current model
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "eltpsffit.h"


void epf1dwmodel(void) {

  int                i;
  double             ps, prof0, prof, contrast;
  char               *buf, buffer[L_WORD];
  extern char        psfimgname[];
  FILE               *data_file;
  extern data1dim    data1d;
  extern fit1dim     fit1d;
  int                getdkeyw(char *, char *, double *);
  double             epf1deval(double, int);
  FILE               *faskwopen(char *, char *, int);
  void               errormsg(char *, ...), nferrormsg(char *, ...);


  strcpy(buffer, psfimgname);
  buf = strstr(buffer, ".fit");

  if (fit1d.nc != 0) {

    /* Write out the model */
    /* Make the file name */
    if (fit1d.type == 1)
      strcpy(buf, ".1dxf");
    else if (fit1d.type == 2)
      strcpy(buf, ".1dyf");
    else if (fit1d.type == 3)
      strcpy(buf, ".1drf");
    else
      errormsg("epf1dwmodel(): Unknown model type: %d!", fit1d.type);

    /* Open the file */
    if ((data_file = faskwopen("1D model file name?", buffer, 4)) == NULL)
      errormsg("epf1dwmodel(): Couldn't open %s!", buffer);
  
    /* Write out */
    fprintf(data_file, "# Description of 1D model\n");
    fprintf(data_file,
	    "# comp h             p [mas]      pi  w [mas]       q\n");
    for (i = 0; i < fit1d.nc; i++)
      fprintf(data_file, "%-4s  %12.5e  %12.5e  %2d  %11.5e  %11.4e\n",
	      fit1d.c[i].type, fit1d.c[i].h, fit1d.c[fit1d.c[i].pi].p,
	      fit1d.c[i].pi, fit1d.c[i].w, fit1d.c[i].q);

    fclose(data_file);
    fprintf(stderr, "\nSaved current model.\n");

    /* Write out the weights and rejection flags */
    /* Make the file name */
    if (fit1d.type == 1)
      strcpy(buf, ".1dxwr");
    else if (fit1d.type == 2)
      strcpy(buf, ".1dywr");
    else if (fit1d.type == 3)
      strcpy(buf, ".1drwr");
    else
      errormsg("epf1dwmodel(): Unknown model type: %d!", fit1d.type);

    /* Open the file */
    if ((data_file = faskwopen("1D weights an rejection flag file name?", 
			       buffer, 4)) == NULL)
      errormsg("epf1dwmodel(): Couldn't open %s!", buffer);
  
    /* Write out */
    fprintf(data_file, "# weight         rejection flag\n");
    for (i = 0; i < data1d.npts; i++)
      fprintf(data_file, "%.8e   %u\n", data1d.s[i], data1d.d[i]);

    fclose(data_file);
    fprintf(stderr, "\nSaved weights and rejection flags.\n");

    if (fit1d.type == 3) {

      /* Write out the radial profile of the PSF fit */    
      /* Make the file name */
      strcpy(buf, ".1dfp");
    
      if (getdkeyw(psfimgname, "CDELT1", &ps))
	errormsg("epf1dwmodel(): Couldn't get CDELT1 keyword!");

      /* Open the file */
      if ((data_file = faskwopen("1D radial profile file name?", buffer, 4)) 
	  == NULL)
	errormsg("epf1dwmodel(): Couldn't open %s!", buffer);
    
      /* Write out */
      fprintf(data_file, "# Radial PSF profile of 1D model\n");
      fprintf(data_file, "# r [mas]      PSF\n");
      prof0 = epf1deval(0.0, fit1d.nc);
      contrast = P_CONT;
      for (i = 0; i < fit1d.nc; i++)
	if (!strcmp(fit1d.c[i].type, "c") && fit1d.c[i].h / prof0 > contrast) {
	  contrast = 1.01 * fit1d.c[i].h / prof0;
	  nferrormsg("Model contains a constant above the desired\n\
contrast level. Resetting contrast to %e.", contrast);
	}
      prof = prof0;
      for (i = 0; prof / prof0 > contrast; i++) {
	prof = epf1deval((double)i * P_STEP * ps, fit1d.nc);
	fprintf(data_file, "%e   %.8e\n", (double)i * P_STEP * ps, prof);
      }

      fclose(data_file);
      fprintf(stderr, "\nSaved radial profile of current model.\n");
    }
  }

  if (fit1d.type == 3) {
    /* Write out the data as well if it hasn't been done before */
    strcpy(buf, ".1dp");
    if (access(buffer, R_OK) == -1) {

      /* Open the file */
      if ((data_file = faskwopen("1D radial profile file name?", buffer, 4)) 
	  == NULL)
	errormsg("epf1dwmodel(): Couldn't open %s!", buffer);
    
      /* Write out */
      fprintf(data_file, "# Radial PSF profile\n");
      fprintf(data_file, "# r [mas]      PSF\n");
      for (i = 0; i < data1d.npts; i++)
	fprintf(data_file, "%e   %.8e\n", data1d.x[i], data1d.y[i]);
      
      fclose(data_file);
      fprintf(stderr, "\nSaved radial profile.\n");
    }
  }
  
  return;
}
