/****************************************************************************
* Fit data with multiple components
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_matrix.h>
#include "eltpsffit.h"


void epfs2ddofit(void) {

  int                i, j, npts, na;
  double             *x, *y, *s, *a, *err, chisq;
  extern datas2dim   datas2d;
  extern fits2dim    fits2d;
  int                fepfmcs2d(const gsl_vector *, void *, gsl_vector *,
			       gsl_matrix *);
  void               errormsg(char *, ...), nferrormsg(char *, ...),
    /*
                     epfs2dfs(void),
    */
                     nlfit(double *, double *, double *, int, double *,
			   double *, int, double *, 
			   int (*)(const gsl_vector *, void *, gsl_vector *,
				   gsl_matrix *));


  if (fits2d.nc == 0) {
    nferrormsg("Nothing to fit!");
    return;
  }

  /* Count the number of parameters to be fit */
  na = 0;
  for (i = 0; i < fits2d.nc; i++)
    na += fits2d.c[i].npar;

  /* Allocate some memory */
  if ((x = (double *)calloc(datas2d.img->npts, sizeof(double))) == NULL)
    errormsg("epfs2ddofit(): Couldn't allocate memory!");
  if ((y = (double *)calloc(datas2d.img->npts, sizeof(double))) == NULL)
    errormsg("epfs2ddofit(): Couldn't allocate memory!");
  if ((s = (double *)calloc(datas2d.img->npts, sizeof(double))) == NULL)
    errormsg("epfs2ddofit(): Couldn't allocate memory!");
  if ((a = (double *)calloc(na, sizeof(double))) == NULL)
    errormsg("epfs2ddofit(): Couldn't allocate memory!");
  if ((err = (double *)calloc(na, sizeof(double))) == NULL)
    errormsg("epfs2ddofit(): Couldn't allocate memory!");

  /* Copy the data */
  npts = 0;
  for (i = 0; i < datas2d.img->npts; i++)
    if (!datas2d.d[i]) {
      x[npts] = datas2d.x[i];
      y[npts] = datas2d.img->i[i];
      s[npts] = datas2d.s[i];
      npts++;
    }

  /* Copy the parameters over */
  j = 0;
  for (i = 0; i < fits2d.nc; i++) {
    a[j++] = fits2d.c[i].h;
    if (strcmp(fits2d.c[i].type, "c")) {
      a[j++] = fits2d.c[i].w;
      a[j++] = fits2d.c[i].rr;
    }
    if (!strcmp(fits2d.c[i].type, "o") || !strcmp(fits2d.c[i].type, "m"))
      a[j++] = fits2d.c[i].q;
    if (fits2d.c[i].pi == i) {
      a[j++] = fits2d.c[i].p.x;
      a[j++] = fits2d.c[i].p.y;
    }
  }
  if (j != na)
    errormsg("epfs2ddofit(): Something is very wrong!");

  /* Do the fit */
  nlfit(x, y, s, npts, a, err, na, &chisq, fepfmcs2d);

  /* Copy the parameters back */
  j = 0;
  for (i = 0; i < fits2d.nc; i++) {
    fits2d.c[i].h = a[j++];
    if (strcmp(fits2d.c[i].type, "c")) {
      fits2d.c[i].w = a[j++];
      fits2d.c[i].rr = a[j++];
    }
    if (!strcmp(fits2d.c[i].type, "o") || !strcmp(fits2d.c[i].type, "m"))
      fits2d.c[i].q = a[j++];
    if (fits2d.c[i].pi == i) {
      fits2d.c[i].p.x = a[j++];
      fits2d.c[i].p.y = a[j++];
    } 
  }
  
  /* Print results */
  printf("\nResult:\n");
  for (i = 0; i < na; i++)
    printf("a_%-2d = %-12g +/- %g\n", i, a[i], err[i]);
  /*
  epfs2dfs();
  */

  /* Clean up */
  free(x);
  free(y);
  free(s);
  free(a);
  free(err);

  return;
}
