/*****************************************************************************
* Evaluate the current fit;
* x is a pixel number;
*****************************************************************************/

#include <string.h>
#include <math.h>
#include "eltpsffit.h"


double epfs2deval(double x, int ic) {

  double            r;
  point             p;
  extern datas2dim  datas2d;
  extern fits2dim   fits2d;
  double            dist2pt(point, point), epfs2dreval(double, int);


  p.x = ((double)((int)rint(x) % datas2d.img->nx) + 1.0) 
    * datas2d.img->wcs->cdelt[0];
  p.y = ((double)((int)rint(x) / datas2d.img->nx) + 1.0) 
    * datas2d.img->wcs->cdelt[1];

  r = dist2pt(p, fits2d.c[0].p);

  return epfs2dreval(r, ic);
}
