/*****************************************************************************
* Evaluate the current fit
*****************************************************************************/

#include <string.h>
#include <math.h>
#include "const.h"
#include "eltpsffit.h"


double epfs2dreval(double r, int ic) {

  int             i, imin, imax;
  double          arg, w, res;
  extern fits2dim fits2d;
  double          sinc(double), airy_disk(double, double),
                  airy_disk_obs(double, double, double);
  void            errormsg(char *, ...);


  imin = 0;
  imax = fits2d.nc;
  if (ic >= 0 && ic < fits2d.nc) {
    imin = ic; 
    imax = ic + 1;
  }

  res = 0.0;
  for (i = imin; i < imax; i++) {
    if (!strcmp(fits2d.c[i].type, "g")) {
      arg = (r - fits2d.c[i].rr) / fits2d.c[i].w;
      res += fits2d.c[i].h * exp(-arg * arg);

    } else if (!strcmp(fits2d.c[i].type, "l")) {
      arg = (r - fits2d.c[i].rr) / fits2d.c[i].w;
      res += fits2d.c[i].h / (arg * arg + 1.0);

    } else if (!strcmp(fits2d.c[i].type, "m")) {
      arg = (r - fits2d.c[i].rr) / fits2d.c[i].w;
      res += fits2d.c[i].h / pow(arg * arg + 1.0, fits2d.c[i].q);
      
    } else if (!strcmp(fits2d.c[i].type, "s")) {
      arg = (r - fits2d.c[i].rr) / fits2d.c[i].w;
      res += fits2d.c[i].h * sinc(arg);

    } else if (!strcmp(fits2d.c[i].type, "a")) {
      arg = (r - fits2d.c[i].rr) * RPMAS;
      w = fits2d.c[i].w * RPMAS;
      if (fabs(arg / w) < AIRC)
	res += fits2d.c[i].h * airy_disk(w, arg);

    } else if (!strcmp(fits2d.c[i].type, "o")) {
      arg = (r - fits2d.c[i].rr) * RPMAS;
      w = fits2d.c[i].w * RPMAS;
      if (fabs(arg / w) < AIRC)
	res += fits2d.c[i].h * airy_disk_obs(w, fits2d.c[i].q, arg);

    } else if (!strcmp(fits2d.c[i].type, "c")) {
      res += fits2d.c[i].h;

    } else
      errormsg("epfs2deval(): Unknown component type: %s", fits2d.c[i].type);
  }

  return res;
}
