/****************************************************************************
* Read in a model
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include "eltpsffit.h"


void epfs2drmodel(void) {

  int                i, j, nwr;
  unsigned short     *d;
  double             *r, *w, radius; 
  char               *buf, nbuffer[L_WORD], buffer[L_WORD];
  extern char        psfimgname[];
  FILE               *data_file;
  point              p;
  extern datas2dim   datas2d;
  extern fits2dim    fits2d;
  int                nlines(FILE *), sidxndval(double *, int, double);
  double             dist2pt(point, point);
  FILE               *faskropen(char *, char *, int);
  point              eltpsffc(image *, char *, int);
  void               errormsg(char *, ...);


  /* Make the file name */
  strcpy(nbuffer, psfimgname);
  buf = strstr(nbuffer, ".fit");
  strcpy(buf, ".s2df");
  if (access(nbuffer, R_OK) == -1) {
    strcpy(buf, ".1drf");
    if (access(nbuffer, R_OK) == -1)
      return;
  }

  /* Open the file */
  if ((data_file = faskropen("s2D model file name?", nbuffer, 4)) == NULL)
    errormsg("epfs2drmodel(): Couldn't open %s!", nbuffer);
  
  fits2d.nc = nlines(data_file);

  /* Make some memory */
  if ((fits2d.c = (fitcs2dim *)realloc(fits2d.c, 
				       fits2d.nc * sizeof(fitcs2dim))) == NULL)
    errormsg("epfs2drmodel(): Couldn't reallocate memory!");

  /* Read in the data */
  p = eltpsffc(datas2d.img, psfimgname, 0);
  p.x *= datas2d.img->wcs->cdelt[0];
  p.y *= datas2d.img->wcs->cdelt[1];
  i = 0;
  while (i < fits2d.nc && fgets(buffer, L_WORD, data_file) != NULL)
    if (buffer[0] != '#') {
      if (!strcmp(buf, ".s2df")) {
	if (sscanf(buffer, "%s %lf %lf %lf %d %lf %lf %lf", fits2d.c[i].type,
		   &(fits2d.c[i].h), &(fits2d.c[i].p.x), &(fits2d.c[i].p.y),
		   &(fits2d.c[i].pi), &(fits2d.c[i].w), &(fits2d.c[i].q),
		   &(fits2d.c[i].rr)) != 8)
	  errormsg("epfs2drmodel(): Having trouble reading the data!");

      } else {
	if (sscanf(buffer, "%s %lf %lf %d %lf %lf", fits2d.c[i].type,
		   &(fits2d.c[i].h), &(fits2d.c[i].rr), &(fits2d.c[i].pi),
		   &(fits2d.c[i].w), &(fits2d.c[i].q)) != 6)
	  errormsg("epfs2drmodel(): Having trouble reading the data!");

	/* All components must have the same centre */
	fits2d.c[i].p = p;
	fits2d.c[i].pi = 0;
      }

      /* Number of parameters */
      if (!strcmp(fits2d.c[i].type, "c")) {
	fits2d.c[i].npar = 1;
	fits2d.c[i].qfit = 0;
      } else if (!strcmp(fits2d.c[i].type, "o") || 
		 !strcmp(fits2d.c[i].type, "m")) {
	fits2d.c[i].npar = (fits2d.c[i].pi == i) ? 6 : 4;
	fits2d.c[i].qfit = 1;
      } else {
	fits2d.c[i].npar = (fits2d.c[i].pi == i) ? 5 : 3;
	fits2d.c[i].qfit = 0;
      }
      
      /* Initialise the rest of the fitting flags */
      fits2d.c[i].hfit = 1;
      fits2d.c[i].wfit = (!strcmp(fits2d.c[i].type, "c")) ? 0 : 1;
      fits2d.c[i].pfit = (fits2d.c[i].pi == i) ? 1 : 0;
      fits2d.c[i].rrfit = (fits2d.c[i].rr > 0.0 && 
			   strcmp(fits2d.c[i].type, "c")) ? 1 : 0;

      i++;
    }
  fits2d.nc = i;
  fclose(data_file);
  fprintf(stderr, "\nRead model.\n");

  /* Read in weights and rejection flag */
  /* Make the file name */
  strcpy(buf, ".1drwr");

  if ((data_file = faskropen("File name?", nbuffer, 4)) == NULL)
    errormsg("epfs2drmodel(): Couldn't open %s!", nbuffer);

  nwr = nlines(data_file);

  /* Make some memory */
  if ((r = (double *)calloc(nwr, sizeof(double))) == NULL)
    errormsg("epfs2drmodel(): Couldn't allocate memory!");
  if ((w = (double *)calloc(nwr, sizeof(double))) == NULL)
    errormsg("epfs2drmodel(): Couldn't allocate memory!");
  if ((d = (unsigned short *)calloc(nwr, sizeof(unsigned short))) == NULL)
    errormsg("epfs2drmodel(): Couldn't allocate memory!");

  /* Read in the data */
  i = 0;
  while (i < nwr && fgets(buffer, L_WORD, data_file) != NULL)
    if (buffer[0] != '#') {
      if (sscanf(buffer, "%lf %hu", &(w[i]), &(d[i])) != 2)
	errormsg("epfs2drmodel(): Having trouble reading the data!");
      r[i] = (double)i * datas2d.img->wcs->cdelt[0];
      i++;
    }
  nwr = i;
  fclose(data_file);

  /* Translate the weights */
  for (i = 0; i < datas2d.img->npts; i++) {
    p.x = ((double)((int)rint(datas2d.x[i]) % datas2d.img->nx) + 1.0) 
      * datas2d.img->wcs->cdelt[0];
    p.y = ((double)((int)rint(datas2d.x[i]) / datas2d.img->nx) + 1.0) 
      * datas2d.img->wcs->cdelt[1];
    radius = dist2pt(p, fits2d.c[0].p);
    if (radius > r[nwr-1])
      datas2d.d[i] = 1;
    else {
      j = sidxndval(r, nwr, radius);
      datas2d.s[i] = sqrt(1.0 + 2.0*PI*radius/datas2d.img->wcs->cdelt[0]) 
	* w[j];
      datas2d.d[i] = d[j];
    }
  }

  /* Clean up */
  free(r);
  free(w);
  free(d);

  fprintf(stderr, "\nRead weights and rejection flags.\n");

  return;
}
