/******************************************************************************
* Compare two floats
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>


int fcmp(float oa, float ob, int maxulp) {

  int    d;
  union  irep {
               float   fval;
               int     ival;
         } a, b;
  void   errormsg(char *, ...);


  if (oa == ob)
    return 1;

  if (maxulp <= 0 || maxulp > 1024)
    errormsg("fcmp(): Bad value for maxulp: %d", maxulp);

  if (isnan(oa) || isnan(ob))
    errormsg("fcmp(): One of the numbers is NaN!");
  if (isinf(oa) || isinf(ob))
    errormsg("fcmp(): One of the numbers is inf or -inf!");

  a.fval = oa;
  b.fval = ob;

  if (a.ival < 0)
    a.ival = 0x80000000 - a.ival;
  if (b.ival < 0)
    b.ival = 0x80000000 - b.ival;

  d = abs(a.ival - b.ival);

  if (d >= 0 && d <= maxulp)
    return 1;

  return 0;
}
