/******************************************************************************
* Send a fatal error message to the terminal, print the CFITSIO error and exit
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <fitsio.h>


void ferrormsg(int status, char *fmt, ...) {

  va_list       args;
  extern char   *progname;
  

  va_start(args, fmt);
  fprintf(stderr, "\n\a%s: FATAL ERROR: ", progname);
  vfprintf(stderr, fmt, args);
  fprintf(stderr, "\n");
  fits_report_error(stderr, status);
  fprintf(stderr, "\n");
  exit(status);
}
