/*****************************************************************************
* Open a fits file for reading with optional file name query, checking whether
* the file exists and system escape.
* Options:
* 1 = don't have a default filename
* 2 = have a default, but query the user
* 3 = have a default, query only if the file doesn't exist
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fitsio.h>


fitsfile *fitsaskropen(char *query, char *filename, int opt) {

  int        status;
  fitsfile   *fptr;
  void       errormsg(char *, ...), get_input(char *, char *, ...);


  if (opt == 1)
    get_input(query, "!%s", filename);
  else if (opt == 2)
    get_input(query, "%s", filename);
  else if (opt == 3)
    ;
  else
    errormsg("fitsaskropen(): Unknown option: %d", opt);

  status = 0;
  while (fits_open_file(&fptr, filename, READONLY, &status) 
	 || filename[0] == '!') {
    if (filename[0] == '!')
      system(filename+1);
    else {
      fits_report_error(stderr, status);
      fprintf(stderr, "\a\n");
      status = 0;
    }
    get_input(query, "!%s", filename);
  }

  return fptr;
}
