/******************************************************************************
* Determine the flux centre of an object in image coordinates
******************************************************************************/

#include <math.h>
#include "img.h"
#include "geom.h"


point fluxcent(image *img, double bckg) {

  int     i;
  double  flux;
  point   c;


  flux = 0.0;
  c.x = 0.0;
  c.y = 0.0;
  for (i = 0; i < img->npts; i++) {
    if (!isnan(img->i[i])) {
      c.x += (img->i[i] - bckg) * (1.0 + i % img->nx);
      c.y += (img->i[i] - bckg) * (1.0 + i / img->nx);
      flux += (double)(img->i[i] - bckg);
    }
  }
  c.x /= flux;
  c.y /= flux;

  return c;
}
