/*****************************************************************************
* 2D geometry definition file
*****************************************************************************/

#ifndef J_GEOM_H

#define J_GEOM_H

/* Structures */

typedef struct Point {
  double   x;
  double   y;
} point;

typedef struct Line {
  point    pt1;
  point    pt2;
} line;

typedef struct Sline {
  double   c;
  double   m;
} sline;

typedef struct Square {
  point    c;
  double   s;
} square;

typedef struct Rect {
  point    ll;
  point    ur;
} rect;

typedef struct Grect {
  point    c;
  double   w;
  double   h;
  double   alpha;
} grect;

typedef struct Quad {
  point    p[4];
} quad;

typedef struct Circle {
  point    c;
  double   r;
} circle;

typedef struct Ellipse {
  point    c;
  double   maj;
  double   min;
  double   alpha;
} ellipse;

typedef struct Annulus {
  point    c;
  double   rin;
  double   rout;
} annulus;

typedef struct Eannulus {
  point    c;
  double   majin;
  double   minin;
  double   majout;
  double   minout;
  double   alpha;
} eannulus;

typedef struct Poly {
  int      npts;
  point    *p;
} poly;

#endif
