/******************************************************************************
* Get a command either interactively from a cpgplot interface or from a 
* command file (which may be stdin); commands read from a command file
* (not stdin) are echoed to terminal; command file EOF returns control to 
* interactive cpgplot interface if there is one, or else 'quits';
* commands to interrupt and continue in command file mode are also handled 
* here to avoid having to deal with them in every calling routine
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <cpgplot.h>
#include "iact.h"


void getcom(int mode, int pos, float xref, float yref, icom *com) {

  int           i;
  char          buffer[100];
  extern char   *progname;
  int           getscbc(char *, int);
  void          nferrormsg(char *, ...);


  if (com->cf) {
    fprintf(stderr, "%s> ", progname);

    if ((com->cfile != stdin && fgets(com->c, com->csize, com->cfile) == NULL)
	|| (com->cfile == stdin && getscbc(com->c, com->csize) == -1)) {
      if (com->nodisp) {
	com->c[0] = 'Q' - 64;
      } else {
	com->cf = 0;
	fprintf(stderr, "\n");
	com->c[0] = '\n';
      }

    } else {
      if (com->cfile != stdin) {
	fprintf(stderr, "%s", com->c);
	com->c[strlen(com->c)-1] = '\0';
      }
      if (com->c[0] == '^') {
	com->c[0] = com->c[1] - 32 - 64;
	com->c[1] = ' ';
      }
      sscanf(com->c+1, "%f %f", &(com->x), &(com->y));
    }

  } else {
    i = 100;
    cpgqinf("type", buffer, &i);
    if (!strcmp(buffer, "XJWINDOW") || !strcmp(buffer, "XISERVE")) {
#ifndef NO_PGPATCH
      cpgjband(mode, pos, xref, yref, &(com->x), &(com->y), &(com->xp), 
	       &(com->yp), com->c, &(com->drag));
#else
      fprintf(stderr, "getcom(): Something is very wrong!");
#endif
    } else {
      cpgband(mode, pos, xref, yref, &(com->x), &(com->y), com->c);
      com->drag = 0;
      com->xp = com->x;
      com->yp = com->y;
    }
  }    

  if (com->c[0]+64 == 'I') {
    com->c[0] = '\n';
    if (com->cf) {
      if (com->nodisp)
	nferrormsg("No interactive device to return to!");
      else
	com->cf = 0;
    } else
      nferrormsg("Not in command file mode!");

  } else if (com->c[0]+64 == 'C') {
    com->c[0] = '\n';
    if (com->cf)
      nferrormsg("Already in command file mode!");
    else if (com->cfile == NULL || com->cfile == stdin)
      nferrormsg("No command file to continue with!");
    else
      com->cf = 1;
  }

  return;
}
