/******************************************************************************
* Get a double valued keyword from a fits image or a header file
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <libgen.h>
#include <fitsio.h>

#define   L_WORD   1000  /* Longest string that can be handled */


int getdkeyw(char *imgname, char *okeyw, double *val) {

  int        status, flag, zip, fits;
  char       *buf, *base, keyw[9], buffer[L_WORD], imgn[L_WORD],
             imgnne[L_WORD], extn[10], headn[L_WORD], card[81];
  FILE       *data_file;
  fitsfile   *fptr;
  fitsfile   *fitsaskropen(char *, char *, int);
  void       errormsg(char *, ...), ferrormsg(int, char *, ...),
             strtoup(char *);


  /* Strip anything in excess of eight characters off the keyword */
  buf = strncpy(keyw, okeyw, 8);
  keyw[8] = '\0';

  /* Pad with white spaces */
  while (*buf != '\0')
    buf++;
  while (buf != keyw+8) {
    *buf = ' ';
    buf++;
  }

  /* Make sure everything is in upper case */
  strtoup(keyw);

  zip = fits = 0;

  /* Strip any .gz or .Z off the image name */
  strcpy(imgn, imgname);
  if ((buf = strstr(imgn, ".gz")) != NULL) {
    *buf = '\0';
    zip = 1;
  } else if ((buf = strstr(imgn, ".Z")) != NULL) {
    *buf = '\0';
    zip = 1;
  }

  /* Does the file name have an extension? */
  strcpy(buffer, imgn);
  base = basename(buffer);
  strcpy(extn, "");
  strcpy(imgnne, imgn);
  if ((buf = strrchr(base, '.')) != NULL) {
    strcpy(extn, buf);
    if ((buf = strstr(imgnne, extn)) != NULL)
      *buf = '\0';
  }

  /* Is it a fits file? */
  if (!strncmp(extn, ".fit", 3))
    fits = 1;

  /* Try to find header file */
  flag = 1;
  strcpy(headn, imgn);
  if (access(strcat(headn, ".hdr"), R_OK)) {
    strcpy(headn, imgnne);
    if (access(strcat(headn, ".hdr"), R_OK)) {
      strcpy(headn, imgnne);
      strcat(headn, ".hdr");
      if (access(strcat(headn, extn), R_OK))
	flag = 0;
    }
  }

  if (flag && (!fits || (fits && zip))) {

    /* Open the header file */
    if ((data_file = fopen(headn, "r")) == NULL)
      errormsg("getdkeyw(): Couldn't open %s!", headn);
    
    flag = 1;
    while (fgets(card, 81, data_file) != NULL)
      if (!strncmp(card, keyw, 8)) {
	if ((buf = strchr(card, '=')) == NULL || buf != card+8)
	  errormsg("getdkeyw(): Fits card is malformed:\n%s", card);
	if (sscanf(buf+1, "%lf", val) != 1)
	  errormsg("getdkeyw(): Couldn't read keyword value from fits\
 card:\n%s", card);
	flag = 0;
	break;
      }

    /* Close the header file */
    fclose(data_file);

  } else if (fits) {

    status = flag = 0;

    /* Open the fits file */
    fptr = fitsaskropen("Fits file to read?", imgname, 3);

    /* Get the keyword */
    fits_read_key(fptr, TDOUBLE, keyw, val, 0, &flag);
    
    /* Close the fits file */
    if (fits_close_file(fptr, &status))
      ferrormsg(status, "getdkeyw(): Couldn't close %s!", imgn);

  } else
    flag = 1;

  return flag;
}
