/******************************************************************************
* Uses subdivision to find the fraction of the grect that is inside the 
* ellipse.
******************************************************************************/

#include <math.h>
#include "const.h"
#include "geom.h"


double grectinel_sub(grect g, ellipse e, int nsub) {

  int          i, nsubsq, pin;
  double       wn, hn, wc, hc;
  point        pr[4], p;
  line         gside;
  int          ptinel(point, ellipse), ptingrect(point, grect),
               linecel(line, ellipse);
  point        transrot(point, point, double, int);

  
  /* Make the edges of the grect */
  pr[0].x = pr[3].x = -0.5 * g.w;
  pr[1].x = pr[2].x = 0.5 * g.w;
  pr[0].y = pr[1].y = -0.5 * g.h;
  pr[2].y = pr[3].y = 0.5 * g.h;
  for (i = 0; i < 4; i++)
    pr[i] = transrot(pr[i], g.c, g.alpha, 1);

  /* Check whether any sides cross the ellipse */
  for (i = 0; i < 4; i++) {
    gside.pt1 = (i == 0) ? pr[3] : pr[i-1];
    gside.pt2 = pr[i];
    if (linecel(gside, e) == 1)
      break;
  }

  if (i == 4) {
    /* Either one object is fully contained in the other or they are 
       completely disjoint */
    for (i = 0; i < 4; i++)
      if (ptinel(pr[i], e) == 1)
	return 1.0;
    
    if (ptingrect(e.c, g))
      return PI * e.maj * e.min / (g.w * g.h);

    return 0.0;
  }

  /* Part of the grect is inside the ellipse */
  nsubsq = nsub * nsub;
  wc = 0.5 * (1.0 / (double)nsub - 1.0);
  hc = wc * g.h;
  wc *= g.w;
  wn = g.w / (double)nsub;
  hn = g.h / (double)nsub;
  pin = 0;
  for (i = 0; i < nsubsq; i++) {
    p.x = wc + (double)(i % nsub) * wn;
    p.y = hc + (double)(i / nsub) * hn;
    p = transrot(p, g.c, g.alpha, 1);
    if (ptinel(p, e))
      pin++;
  }
  return (double)pin / (double)nsubsq;
}
