/******************************************************************************
* Find array index of a fit component
* pp indicates which point (central, half-maximum or first peak) was picked
******************************************************************************/

#include <string.h>
#include <math.h>
#include <cpgplot.h>
#include "eltpsffit.h"


int idxfitc1d(fitc1dim *fitc, int n, float x, float y, int *pp) {

  int              i, ni;
  float            help=1.0e6, x1, x2, y1, y2, f;
  extern env1dim   env1d;


  /* Get a scale factor to make x-distances comparable to y-distances */
  cpgqwin(&x1, &x2, &y1, &y2);
  f = (x2 - x1) / (y2 - y1);
  cpgqvp(0, &x1, &x2, &y1, &y2);
  f /= (x2 - x1) / (y2 - y1);
  cpgqvsz(2, &x1, &x2, &y1, &y2);
  f /= (x2 - x1) / (y2 - y1);
  
  ni = -1;
  *pp = 0;
  for (i = 0; i < n; i++) {
    if (env1d.logp && fitc[i].h < 0.0)
      /* Skip negative components on log plots */
      continue;

    /* Central point */
    if (sqrt(pow((x - fitc[fitc[i].pi].p) / f, 2.0) + pow(y - fitc[i].h, 2.0))
	< help) {
      ni = i;
      *pp = 1;
      help = sqrt(pow((x - fitc[fitc[i].pi].p) / f, 2.0) +
		  pow(y - fitc[i].h, 2.0));
    }
    
    /* HWHM point */
    if (strcmp(fitc[i].type, "c")) {
      if (sqrt(pow((x - (fitc[fitc[i].pi].p + fitc[i].hwhm)) / f, 2.0) +
	       pow(y - fitc[i].h / 2.0, 2.0)) < help) {
	ni = i;
	*pp = 2;
	help = sqrt(pow((x - (fitc[fitc[i].pi].p + fitc[i].hwhm)) / f, 2.0) +
		    pow(y - fitc[i].h / 2.0, 2.0));
      }
    }

    /* Additional point */
    if (!strcmp(fitc[i].type, "o") || !strcmp(fitc[i].type, "m")) {
      if (sqrt(pow((x - (fitc[fitc[i].pi].p + fitc[i].fmx)) / f, 2.0) +
	       pow(y - fitc[i].h * fitc[i].fmy, 2.0)) < help) {
	ni = i;
	*pp = 3;
	help = sqrt(pow((x - (fitc[fitc[i].pi].p + fitc[i].fmx)) / f, 2.0) +
		    pow(y - fitc[i].h * fitc[i].fmy, 2.0));
      }
    }
  }

  return ni;
}
