/******************************************************************************
* Definitions for use in image software
******************************************************************************/

#ifndef J_IMG_H

#define J_IMG_H

#include <wcs.h>

/* Definitions */

#define  NULVAL  0.0      /* Value for non-defined pixels */
#define  L_WORD  2000     /* Longest string that can be handled */

/* Structures */

typedef struct Image {
  int               npts;
  int               nx;
  int               ny;
  double            ltv[2];
  double            ltm[2][2];
  double            ltmi[2][2];
  struct WorldCoor  *wcs;
  float             *i;
} image;

typedef struct Dimage {
  int               npts;
  int               nx;
  int               ny;
  double            ltv[2];
  double            ltm[2][2];
  double            ltmi[2][2];
  struct WorldCoor  *wcs;
  double            *i;
} dimage;

typedef struct Jpgimage {
  int               npts;
  int               nx;
  int               ny;
  float             cmap[256][3];
  int               *i;
} jpgimage;

typedef struct Plenv {
  float    xmin;
  float    xmax;
  float    ymin;
  float    ymax;
  float    zmin;
  float    zmax;
  float    zcmin;
  float    zcmax;
  int      grey;
  int      con;
  int      phys;
  int      nc;
  char     xlab[L_WORD];
  char     ylab[L_WORD];
  char     title[L_WORD];
} plenv;

#endif
