/******************************************************************************
* Plot an image
******************************************************************************/

#include <stdlib.h>
#include <math.h>
#include <cpgplot.h>
#include "img.h"


void ipplot(image *img, plenv *env) {

  int            i, just;
  float          tr[6], *cont;
  void           errormsg(char *, ...);


  just = 1;
  if (env->phys) {
    tr[0] = -img->ltv[0] * img->ltmi[0][0] + -img->ltv[1] * img->ltmi[0][1]; 
    tr[1] = img->ltmi[0][0];
    tr[2] = img->ltmi[0][1];
    tr[3] = -img->ltv[0] * img->ltmi[1][0] + -img->ltv[1] * img->ltmi[1][1]; 
    tr[4] = img->ltmi[1][0];
    tr[5] = img->ltmi[1][1];
    if (fabs(fabs(img->ltm[0][0] * img->ltm[1][1] - 
		  img->ltm[1][0] * img->ltm[0][1]) - 1.0) > 1.0e-4)
      just = 0;
  } else {
    tr[0] = 0.0; tr[1] = 1.0; tr[2] = 0.0;
    tr[3] = 0.0; tr[4] = 0.0; tr[5] = 1.0;
  }

  cpgbbuf();
  cpgscr(0, 0.184, 0.31, 0.31);
  cpgenv(env->xmin, env->xmax, env->ymin, env->ymax, just, 0);
  cpgscr(0, 0.0, 0.0, 0.0);

  if (env->grey)
    cpggray(img->i, img->nx, img->ny, 1, img->nx, 1, img->ny, env->zmax,
	    env->zmin, tr);

  if (env->con) {
    if ((cont = (float *)calloc(env->nc, sizeof(float))) == NULL)
      errormsg("ipplot(): Couldn't allocate memory!");
    for (i = 0; i < env->nc; i++)
      cont[i] = env->zcmin + (float)i * (env->zcmax - env->zcmin) / 
	(float)(env->nc - 1);
    cpgsci(1);
    cpgcont(img->i, img->nx, img->ny, 1, img->nx, 1, img->ny, cont, env->nc,
	    tr);
    free(cont);
  }

  cpgsci(5);
  cpgbox("BCST", 0.0, 0, "BCST", 0.0, 0);
  cpgsci(7);
  cpgbox("N", 0.0, 0, "N", 0.0, 0);
  cpgsci(3);
  cpglab(env->xlab, env->ylab, env->title);
  cpgsci(1);
  cpgebuf();

  return;
}
