/******************************************************************************
* Function to window an image plot
* wcom options:  0  interactive
                 1  like w a
		 2  translate existing window limits logical/image <-> physical
******************************************************************************/

#include <stdio.h>
#include <cpgplot.h>
#include "img.h"


void iwindowing(float *x, float *y, plenv *env, image *img, int wcom) {

  float            help;
  double           xmin, xmax, ymin, ymax, xp, yp;
  char             com;
  void             errormsg(char *, ...),
                   img2phys(image *, double, double, double *, double *),
                   phys2img(image *, double, double, double *, double *);


  if (wcom == 1) {
    if (env->phys) {
      img2phys(img, 0.0, 0.0, &xmin, &ymin);
      img2phys(img, img->nx + 1.0, img->ny + 1.0, &xmax, &ymax);
      env->xmin = (xmin < xmax) ? xmin : xmax;
      env->xmax = (xmin < xmax) ? xmax : xmin;
      env->ymin = (ymin < ymax) ? ymin : ymax;
      env->ymax = (ymin < ymax) ? ymax : ymin;
    } else {
      env->xmin = 0.0;
      env->xmax = img->nx + 1.0;
      env->ymin = 0.0;
      env->ymax = img->ny + 1.0;
    }

  } else if (wcom == 2) {
    if (env->phys) {
      img2phys(img, env->xmin, env->ymin, &xmin, &ymin);
      img2phys(img, env->xmax, env->ymax, &xmax, &ymax);
      img2phys(img, *x, *y, &xp, &yp);
      *x = xp;
      *y = yp;
    } else {
      phys2img(img, env->xmin, env->ymin, &xmin, &ymin);
      phys2img(img, env->xmax, env->ymax, &xmax, &ymax);
      phys2img(img, *x, *y, &xp, &yp);
      *x = xp;
      *y = yp;
    }
    env->xmin = (xmin < xmax) ? xmin : xmax;
    env->xmax = (xmin < xmax) ? xmax : xmin;
    env->ymin = (ymin < ymax) ? ymin : ymax;
    env->ymax = (ymin < ymax) ? ymax : ymin;

  } else if (wcom == 0) {

    cpgsci(7);

    do {
      cpgband(7, 0, *x, *y, x, y, &com);
    
      if (com == 'a') {
	if (env->phys) {
	  img2phys(img, 0.0, 0.0, &xmin, &ymin);
	  img2phys(img, img->nx + 1.0, img->ny + 1.0, &xmax, &ymax);
	  env->xmin = (xmin < xmax) ? xmin : xmax;
	  env->xmax = (xmin < xmax) ? xmax : xmin;
	  env->ymin = (ymin < ymax) ? ymin : ymax;
	  env->ymax = (ymin < ymax) ? ymax : ymin;
	} else {
	  env->xmin = env->ymin = 0.0;
	  env->xmax = img->nx + 1.0;
	  env->ymax = img->ny + 1.0;
	}

      } else if (com == 'x') {
	env->xmin = *x;
	cpgband(4, 0, env->xmin, *y, &(env->xmax), y, &com);

      } else if (com == 'y') {
	env->ymin = *y;
	cpgband(3, 0, *x, env->ymin, x, &(env->ymax), &com);
	
      } else if (com == 'e' || com == 'A') {
	env->xmin = *x; env->ymin = *y;
	cpgband(2, 1, *x, *y, &(env->xmax), &(env->ymax), &com);
      
      } else if (com == 'l') {
	env->xmin = *x;

      } else if (com == 'r') {
	env->xmax = *x;

      } else if (com == 'b') {
	env->ymin = *y;

      } else if (com == 't') {
	env->ymax = *y;

      } else if (com == 'c') {
	help = env->xmax - env->xmin;
	env->xmax = *x + help / 2.0;
	env->xmin = *x - help / 2.0;
	help = env->ymax - env->ymin;
	env->ymax = *y + help / 2.0;
	env->ymin = *y - help / 2.0;

      } else if (com == '+') {
	help = (env->xmax + env->xmin) / 2.0;
	env->xmax = (help + env->xmax) / 2.0;
	env->xmin = (help + env->xmin) / 2.0;
	help = (env->ymax + env->ymin) / 2.0;
	env->ymax = (help + env->ymax) / 2.0;
	env->ymin = (help + env->ymin) / 2.0;

      } else if (com == '-') {
	help = (env->xmin + env->xmax) / 2.0;
	env->xmax = 2.0 * env->xmax - help;
	env->xmin = 2.0 * env->xmin - help;
	help = (env->ymin + env->ymax) / 2.0;
	env->ymax = 2.0 * env->ymax - help;
	env->ymin = 2.0 * env->ymin - help;

      } else if (com == '>') {
	help = env->xmin;
	env->xmin = env->xmax;
	env->xmax = help;

      } else if (com == '^') {
	help = env->ymin;
	env->ymin = env->ymax;
	env->ymax = help;

      } else if (com == '/') {
	help = env->xmin;
	env->xmin = env->xmax;
	env->xmax = help;
	help = env->ymin;
	env->ymin = env->ymax;
	env->ymax = help;

      } else if (com == 'u') {
	help = (env->ymax - env->ymin) / 2.0;
	env->ymax += help;
	env->ymin += help;

      } else if (com == 'j') {
	help = (env->ymax - env->ymin) / 2.0;
	env->ymax -= help;
	env->ymin -= help;

      } else if (com == 'k') {
	help = (env->xmax - env->xmin) / 2.0;
	env->xmax += help;
	env->xmin += help;

      } else if (com == 'h') {
	help = (env->xmax - env->xmin) / 2.0;
	env->xmax -= help;
	env->xmin -= help;

      } else if (com == '?') {
	fprintf(stderr, "\nList of windowing commands:\n\n");
	fprintf(stderr, "\t?\t\tprint this list\n \
\ta\t\trestore\n \
\te or lmb\tmagnify\n \
\tx\t\tchoose x limits\n \
\ty\t\tchoose y limits\n \
\tl\t\tchoose xmin\n \
\tr\t\tchoose xmax\n \
\tb\t\tchoose ymin\n \
\tt\t\tchoose ymax\n \
\tc\t\tcentre on cursor position\n \
\t+\t\tzoom in\n \
\t-\t\tzoom out\n \
\t>\t\tflip x-axis\n \
\t^\t\tflip y-axis\n \
\t/\t\tflip both axes\n \
\tu\n \
      h k\t\tmove up, down, left, right\n \
\tj\n");
      }

    } while (com == '?');

    cpgsci(1);
  
  } else
    errormsg("iwindowing(): Unknown windowing command: %d", wcom);

  return;
}
