/*****************************************************************************
* Fit f = c + m*x to y; no errors
*****************************************************************************/

#include <math.h>
#include "geom.h"


void lin_fit_s(float x[], float y[], int npts, sline *s) {

  int     i;
  float   mx, my, msx, mxy;
  void    errormsg(char *, ...);

  
  if (npts < 2)
    errormsg("lin_fit_s(): Not enough points: %d", npts);

  mx = my = msx = mxy = 0.0;
  for (i = 0; i < npts; i++) {
    mx += x[i];
    my += y[i];
    msx += x[i] * x[i];
    mxy += x[i] * y[i];
  }
  mx /= (float)npts;
  my /= (float)npts;
  msx /= (float)npts;
  mxy /= (float)npts;

  s->m = (mxy - mx*my) / (msx - mx*mx);
  s->c = my - s->m * mx;

  return;
}
