/******************************************************************************
* Transform line to sline, i.e. find slope and intercept from two points
******************************************************************************/

#include <math.h>
#include "geom.h"


sline line2sline(line l) {

  sline   sl;
  void    errormsg(char *, ...);
  

  if (l.pt1.x == l.pt2.x)
    errormsg("line2sline(): Infinite slope!");

  sl.m = (l.pt2.y - l.pt1.y) / (l.pt2.x - l.pt1.x);
  sl.c = l.pt1.y - sl.m * l.pt1.x;

  return sl;
}
