/******************************************************************************
* Does the line cross the ellipse?
* 0 = no
* 1 = yes
* 2 = yes, the crossing point is an endpoint
* 3 = yes, at the crossing point the line and the ellipse are parallel (graze)
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include <gsl/gsl_poly.h>
#include "geom.h"


int linecel(line l, ellipse e) {

  int      ns, ip[2];
  double   help;
  point    p[2];
  sline    sl;
  int      fcmp(float, float, int), ptcmp(point, point),
           ptonline(point, line), ptinel(point, ellipse);
  point    transrot(point, point, double, int);
  sline    line2sline(line);
  void     errormsg(char *, ...);


  if (ptcmp(l.pt1, l.pt2))
    errormsg("linecel(): The endpoints of the line are identical!");

  l.pt1 = transrot(l.pt1, e.c, e.alpha, -1);
  l.pt2 = transrot(l.pt2, e.c, e.alpha, -1);

  if (fcmp(l.pt1.x, l.pt2.x, 1)) { 
    /* Line has constant x */

    help = l.pt1.x;
    l.pt1.x = l.pt1.y;
    l.pt1.y = help;

    help = l.pt2.x;
    l.pt2.x = l.pt2.y;
    l.pt2.y = help;
    
    help = e.maj;
    e.maj = e.min;
    e.min = help;
  }

  /* Find the crossing points */
  sl = line2sline(l);
  ns = gsl_poly_solve_quadratic(e.min*e.min / (e.maj*e.maj) + sl.m*sl.m, 
				2.0 * sl.c * sl.m,
				sl.c*sl.c - e.min*e.min, &(p[0].x), &(p[1].x));

  /* Is there a crossing point? */
  if (ns == 0)
    /* The line might come close to the ellipse but I don't know how to 
       deal with this */
    return 0;

  /* Crossing points */
  p[0].y = sl.c + sl.m * p[0].x;
  p[1].y = sl.c + sl.m * p[1].x;

  /* Do any crossing points lie on the line? */
  ip[0] = ptonline(p[0], l);
  ip[1] = ptonline(p[1], l);

  if (ip[0] == 0 && ip[1] == 0) {
    /* Check endpoints */
    e.c.x = 0.0;
    e.c.y = 0.0;
    e.alpha = 0.0;
    if (ptinel(l.pt1, e) == 2 || ptinel(l.pt2, e) == 2)
      return 2;
    else
      return 0;
  } else if ((ip[0] == 2 || ip[1] == 2) && ip[0] + ip[1] != 3)
    return 2;
  else {
    if (ns == 1)
      return 3;
    else
      return 1;
  }
}
