/***************************************************************************** 
* Move and/or resize a window with given name to a given position;
* If uwidth or uheight is <= 0.0 the width or height are not changed
*****************************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>
#include <stdio.h>

Display     *dpy;


int mvreswin(int ux, int uy, int uwidth, int uheight, char *name) {

  int                x, y, screen;
  unsigned int       width, height, bw, depth;
  /* unsigned int nchild; */
  char               *display_name=NULL;
  Window             window=0, root;
  /* Window          parent, *child; */
  Window             window_with_name(Window, char *);
  void               nferrormsg(char *, ...);
  

  /* Connect to X server */
  if ((dpy = XOpenDisplay(display_name)) == NULL) {
    nferrormsg("mvreswin(): Couldn't connect to X server %s!", 
	       XDisplayName(display_name));
    return 0;
  }
  screen = DefaultScreen(dpy);

  /* Get the correct window */
  if (!(window = window_with_name(RootWindow(dpy, screen), name))) {
    nferrormsg("mvreswin(): Couldn't find window with name %s!", name);
    return 0;
  }
  
  /* Get the present geometry of the window */
  /*
  XQueryTree(dpy, window, &root, &parent, &child, &nchild);
  */
  XGetGeometry(dpy, window, &root, &x, &y, &width, &height, &bw, &depth);
  /*
  XTranslateCoordinates(dpy, parent, root, x, y, &x, &y, child);
  */

  /* Move, resize the window */
  width = (uwidth > 0) ? uwidth : width;
  height = (uheight > 0) ? uheight : height; 
  XMoveResizeWindow(dpy, window, ux, uy, width, height);

  /* Disconnect from X server */
  XCloseDisplay(dpy);

  return 1;
}
