/****************************************************************************
* Calculate percentile
****************************************************************************/

#include <stdlib.h>
#include <math.h>
#include <gsl/gsl_sort.h>
#include <gsl/gsl_statistics.h>


double percentile(float array[], int n, double perc) {

  int        i;
  float      *data;
  double     p;
  void       errormsg(char *, ...);


  if (n <= 0)
    errormsg("percentile(): Bad arraysize: %d", n);

  if (perc < 0.0 || perc > 1.0)
    errormsg("percentile(): Bad percentile level: %f", perc);

  if ((data = (float *)calloc(n, sizeof(float))) == NULL)
    errormsg("percentile(): Couldn't allocate memory!");

  for (i = 0; i < n; i++)
    data[i] = array[i];

  gsl_sort_float(data, 1, n);
  p = gsl_stats_float_quantile_from_sorted_data(data, 1, n, perc);

  free(data);

  return p;
}
