/******************************************************************************
* Is the point in the ellipse?
* 0 = outside
* 1 = inside
* 2 = on the ellipse
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include "geom.h"


int ptinel(point p, ellipse e) {

  double   r;
  int      fcmp(float, float, int);
  point    transrot(point, point, double, int);
  void     errormsg(char *, ...);
  

  p = transrot(p, e.c, e.alpha, -1);
  r = p.x*p.x / (e.maj*e.maj) + p.y*p.y / (e.min*e.min);

  if (fcmp(r, 1.0, 1))
    return 2;

  else if (r > 1.0)
    return 0;

  else if (r < 1.0)
    return 1;

  errormsg("ptinel(): You should never get here!");
  return -1;
}
