/******************************************************************************
* Is the point in the grect?
* 0 = outside
* 1 = inside
* 2 = on the edge
******************************************************************************/

#include <stdio.h>
#include "geom.h"


int ptingrect(point p, grect g) {

  int      fcmp(float, float, int);
  point    transrot(point, point, double, int);
  void     errormsg(char *, ...);


  p = transrot(p, g.c, g.alpha, -1);

  if ((fcmp(p.x, -0.5 * g.w, 1) && ((p.y >= -0.5 * g.h && p.y <= 0.5 * g.h) || 
				    fcmp(p.y, -0.5 * g.h, 1) ||
				    fcmp(p.y, 0.5 * g.h, 1))) ||
      (fcmp(p.x, 0.5 * g.w, 1) && ((p.y >= -0.5 * g.h && p.y <= 0.5 * g.h) || 
				   fcmp(p.y, -0.5 * g.h, 1) ||
				   fcmp(p.y, 0.5 * g.h, 1))) ||
      (fcmp(p.y, -0.5 * g.h, 1) && ((p.x >= -0.5 * g.w && p.x <= 0.5 * g.w) || 
				    fcmp(p.x, -0.5 * g.w, 1) ||
				    fcmp(p.x, 0.5 * g.w, 1))) ||
      (fcmp(p.y, 0.5 * g.h, 1) && ((p.x >= -0.5 * g.w && p.x <= 0.5 * g.w) || 
				   fcmp(p.x, -0.5 * g.w, 1) ||
				   fcmp(p.x, 0.5 * g.w, 1))))
    return 2;
  
  else if (p.x < -0.5 * g.w || p.x > 0.5 * g.w || 
	   p.y < -0.5 * g.h || p.y > 0.5 *g.h)
    return 0;
  
  else if (p.x > -0.5 * g.w && p.x < 0.5 * g.w &&
	   p.y > -0.5 * g.h && p.y < 0.5 * g.h)
    return 1;
  
  errormsg("ptingrect(): You should never get here!");
  return -1;
}
