/******************************************************************************
* Does the point lie on the line?
* 0 = no
* 1 = yes
* 2 = point is one of the endpoints
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include "geom.h"


int ptonline(point p, line l) {

  double   xmin, xmax, ymin, ymax, help;
  sline    sl;
  int      ptcmp(point, point), fcmp(float, float, int);
  sline    line2sline(line);
  void     errormsg(char *, ...);


  if (ptcmp(l.pt1, l.pt2))
    errormsg("ptonline(): The endpoints of the line are identical!");

  /* Is the point one of the endpoints? */
  if (ptcmp(p, l.pt1) || ptcmp(p, l.pt2))
    return 2;

  if (fcmp(l.pt1.x, l.pt2.x, 1)) {
    /* Line has constant x */

    help = l.pt1.x;
    l.pt1.x = l.pt1.y;
    l.pt1.y = help;

    help = l.pt2.x;
    l.pt2.x = l.pt2.y;
    l.pt2.y = help;

    help = p.x;
    p.x = p.y;
    p.y = help;
  }
  
  if (fcmp(l.pt1.y, l.pt2.y, 1)) {
    /* Line has constant y */

    /* Does the point lie between the end points of the line? */
    if (l.pt1.x < l.pt2.x) {
      xmin = l.pt1.x;
      xmax = l.pt2.x;
    } else {
      xmin = l.pt2.x;
      xmax = l.pt1.x;
    }
    if (p.x < xmin || p.x > xmax)
      return 0;

    /* Does the point lie on the line? */
    sl = line2sline(l);
    if (fcmp(p.y, sl.c + sl.m * p.x, 1))
      return 1;
    else
      return 0;
  
  } else {
  
    /* Does the point lie between the end points of the line? */
    if (l.pt1.x < l.pt2.x) {
      xmin = l.pt1.x;
      xmax = l.pt2.x;
    } else {
      xmin = l.pt2.x;
      xmax = l.pt1.x;
    }
    if (l.pt1.y < l.pt2.y) {
      ymin = l.pt1.y;
      ymax = l.pt2.y;
    } else {
      ymin = l.pt2.y;
      ymax = l.pt1.y;
    }
    if (p.x < xmin || p.x > xmax || p.y < ymin || p.y > ymax)
      return 0;

    /* Does the point lie on the line? */
    sl = line2sline(l);
    if (fcmp(p.y, sl.c + sl.m * p.x, 1) || fcmp(p.x, (p.y - sl.c) / sl.m, 1))
      return 1;
    else
      return 0;
  }
}
