/*****************************************************************************
* Calculate plotting range
* Options:
* 0 = adjust both min and max
* 1 = adjust only max
* 2 = adjust only min
* >2 = do nothing
*****************************************************************************/

#include <math.h>

#define RANGE  0.05


void range(float data[], int n, float *min, float *max, int opt) {

  float   mi, ma;
  float   jmin(float *, int), jmax(float *, int);
  void    errormsg(char *, ...);


  if (n < 1)
    errormsg("range(): Bad arraysize: %d", n);

  mi = jmin(data, n);
  ma = jmax(data, n);

  if (mi == ma) {
    if (opt == 0) {
      *min = mi - RANGE * fabs(mi);
      *max = ma + RANGE * fabs(ma);
    } else if (opt == 1) {
      *max = ma + RANGE * fabs(ma);
    } else if (opt == 2) {
      *min = mi - RANGE * fabs(mi);
    }
  } else {
    if (opt == 0) {
      *min = mi - RANGE * (ma - mi);
      *max = ma + RANGE * (ma - mi);
    } else if (opt == 1) {
      *max = ma + RANGE * (ma - *min);
    } else if (opt == 2) {
      *min = mi - RANGE * (*max - mi);
    }
  }

  return;
}
