/******************************************************************************
* Read a simple ascii image
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "img.h"


void rasciimg(char *imgname, int opt, image *img) {

  int        i;
  char       buffer[L_WORD];
  FILE       *data_file;
  FILE       *faskropen(char *, char *, int);
  void       errormsg(char *, ...);


  /* Open the file */
  if ((data_file = faskropen("ASCII file to read?", imgname, opt)) == NULL)
    errormsg("rasciimg(): Couldn't open %s!", imgname);

  /* Get the size of the image */
  do {
    if (fgets(buffer, L_WORD, data_file) == NULL)
      errormsg("rasciimg(): Couldn't determine size of %s!", imgname);
  } while (buffer[0] == '#');
  if (sscanf(buffer, "%d %d", &(img->nx), &(img->ny)) != 2)
    errormsg("rasciimg(): Couldn't determine size of %s!", imgname);

  img->npts = img->nx * img->ny;

  /* Allocate memory for the image */
  if ((img->i = (float *)calloc(img->npts, sizeof(float))) == NULL)
    errormsg("rasciimg(): Couldn't allocate memory!");

  /* Read in the image */
  i = 0;
  while (i < img->npts && fgets(buffer, L_WORD, data_file) != NULL)
    if (buffer[0] != '#') {
      if (sscanf(buffer, "%f", &(img->i[i])) != 1)
	errormsg("rasciimg(): Having trouble reading the data!");
      i++;
    }
  fclose(data_file);
  if (i != img->npts)
    errormsg("rasciimg(): Something is very wrong!");

  /* Set the LTV keywords */
  img->ltv[0] = 0.0;
  img->ltv[1] = 0.0;

  /* Set the LTM keywords */
  img->ltm[0][0] = img->ltm[1][1] = img->ltmi[0][0] = img->ltmi[1][1] = 1.0;
  img->ltm[0][1] = img->ltm[1][0] = img->ltmi[0][1] = img->ltmi[1][0] = 0.0;

  /* Set the WCS */
  img->wcs = 0;
}
