/******************************************************************************
* Read a simple 2d fits image
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <fitsio.h>
#include "img.h"


void rfitsimg(char *imgname, int opt, image *img) {

  int        status, anynul;
  float      nulval;
  fitsfile   *fptr;
  fitsfile   *fitsaskropen(char *, char *, int);
  void       errormsg(char *, ...), ferrormsg(int, char *, ...),
             rfitsimghdr(char *, int, image *);


  status = 0;

  /* Fill in the header */
  rfitsimghdr(imgname, opt, img);

  /* Allocate memory for the image */
  if ((img->i = (float *)calloc(img->npts, sizeof(float))) == NULL)
    errormsg("rfitsimg(): Couldn't allocate memory!");

  /* Open the fits file */
  fptr = fitsaskropen("Fits file to read?", imgname, opt);

  /* Read in the image */
  nulval = NULVAL;
  if (fits_read_img(fptr, TFLOAT, 1, img->npts, &nulval, img->i, &anynul,
		    &status))
    ferrormsg(status, "rfitsimg(): Couldn't read %s!", imgname);

  /* Close the fits file */
  if (fits_close_file(fptr, &status))
    ferrormsg(status, "rfitsimg(): Couldn't close %s!", imgname);

  return;
}
