/******************************************************************************
* Find array index of array element nearest to val, 
* where the array is sorted in ascending order; uses a bisection algorithm
******************************************************************************/

#include <math.h>

int sidxnval(float array[], int n, float val) {

  int       ju, jm, jl;


  jl = 0;
  ju = n-1;

  while (ju - jl > 1) {
    jm = (ju + jl) / 2;
    if (val >= array[jm])
      jl = jm;
    else
      ju = jm;
  }
	
  if (fabs(val - array[jl]) < fabs(val - array[ju]))
    return jl;
  else
    return ju;
}
