/******************************************************************************
* Sigma clip array1 according to array2;
* on entry both arrays must be of the same length;
* the length of array1 after clipping is returned
******************************************************************************/

#include <math.h>
#include <gsl/gsl_statistics.h>


int sigclip(float array1[], float array2[], int n, float nsig) {

  int      i, j;
  double   mean, rms;
  void     warnmsg(char *, ...);


  if (n < 2) {
    warnmsg("sigclip(): Not enough points for clipping: %d", n);
    return n;
  }

  mean = gsl_stats_float_mean(array2, 1, n);
  rms = gsl_stats_float_sd_m(array2, 1, n, mean);

  j = 0;
  for (i = 0; i < n; i++)
    if (fabs(array2[i] - mean) / rms < nsig)
      array1[j++] = array1[i];

  return j;
}
