/******************************************************************************
* Translate and rotate a point
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include "const.h"
#include "geom.h"


point transrot(point p, point c, double alpha, int dir) {

  double    alphar;
  point     newp;
  int       fcmp(float, float, int);
  void      errormsg(char *, ...);


  alpha = -alpha;
  if (dir == 1) {
    if (fcmp(alpha, 0.0, 1) || fcmp(alpha, 360.0, 1) ||
	fcmp(alpha, -360.0, 1)) {
      newp.x = c.x + p.x;
      newp.y = c.y + p.y;
    } else if (fcmp(alpha, 90.0, 1) || fcmp(alpha, -270.0, 1)) {
      newp.x = c.x + p.y;
      newp.y = c.y - p.x;
    } else if (fcmp(alpha, 180.0, 1) || fcmp(alpha, -180.0, 1)) {
      newp.x = c.x - p.x;
      newp.y = c.y - p.y;
    } else if (fcmp(alpha, 270.0, 1) || fcmp(alpha, -90.0, 1)) {
      newp.x = c.x - p.y;
      newp.y = c.y + p.x;
    } else {
      alphar = alpha * RPDEG;
      newp.x = c.x + cos(alphar) * p.x + sin(alphar) * p.y;
      newp.y = c.y + cos(alphar) * p.y - sin(alphar) * p.x;
    }
  } else if (dir == -1) {
    if (fcmp(alpha, 0.0, 1) || fcmp(alpha, 360.0, 1) ||
	fcmp(alpha, -360.0, 1)) {
      newp.x = (p.x - c.x);
      newp.y = (p.y - c.y);
    } else if (fcmp(alpha, 90.0, 1) || fcmp(alpha, -270.0, 1)) {
      newp.x = -(p.y - c.y);
      newp.y = (p.x - c.x);
    } else if (fcmp(alpha, 180.0, 1) || fcmp(alpha, -180.0, 1)) {
      newp.x = -(p.x - c.x);
      newp.y = -(p.y - c.y);
    } else if (fcmp(alpha, 270.0, 1) || fcmp(alpha, -90.0, 1)) {
      newp.x = (p.y - c.y);
      newp.y = -(p.x - c.x);
    } else {
      alphar = alpha * RPDEG;
      newp.x = cos(alphar) * (p.x - c.x) - sin(alphar) * (p.y - c.y);
      newp.y = sin(alphar) * (p.x - c.x) + cos(alphar) * (p.y - c.y);
    }
  } else {
    newp.x = 0.0;
    newp.y = 0.0;
    errormsg("transrot(): Unknown option: %d", dir);
  }

  return newp;
}
