/*****************************************************************************
* Subroutine to get the id of a window with given name
*****************************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>
#include <string.h>


Window window_with_name(Window top, char *name) {

  int             i;
  unsigned int    nchildren;
  char            *window_name;
  Window          *children, dummy, w=0;
  extern Display  *dpy;
  void            nferrormsg(char *, ...);

  
  /* Get the name of the top window */
  if (XFetchName(dpy, top, &window_name)) {
    if (!strcmp(window_name, name)) {
      XFree(window_name);
      return top;
    } else
      XFree(window_name);
  }

  /* Find the children */
  if (!XQueryTree(dpy, top, &dummy, &dummy, &children, &nchildren)) {
    nferrormsg("window_with_name(): Couldn't query the tree of window top!");
    return 0;
  }

  /* Recurse down the tree */
  for (i = 0; i < nchildren; i++) {
    w = window_with_name(children[i], name);
    if (w)
      break;
  }

  /* Clean up */
  if (children)
    XFree(children);

  return w;
}
