/******************************************************************************
* Change ZPX WCS to WCSTools understandable ZPN
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>


void zpx2zpn(char *header) {

  int      i, len;
  float    projp1, projp3;
  char     *start, *end, *nend, buf;
  void     nferrormsg(char *, ...);


  /* Fix CTYPE1 */
  if ((start = strstr(header, "CTYPE1")) == NULL)
    return;
  end = start + 80;
  buf = *end;
  *end = '\0';
  if ((nend = strchr(start, '/')) != NULL) {
    *end = buf;
    end = nend;
    buf = *end;
    *end = '\0';
  }
  if ((start = strchr(start, '=')) == NULL) {
    nferrormsg("zpx2zpn(): CTYPE1 keyword string is malformed!");
    *end = buf;
    return;
  }
  start += 1;
  if ((start = strstr(start, "-ZPX")) == NULL) {
    *end = buf;
    return;
  }
  start += 3;
  *start = 'N';
  *end = buf;

  /* Fix CTYPE2 */
  if ((start = strstr(header, "CTYPE2")) == NULL)
    return;
  end = start + 80;
  buf = *end;
  *end = '\0';
  if ((nend = strchr(start, '/')) != NULL) {
    *end = buf;
    end = nend;
    buf = *end;
    *end = '\0';
  }
  if ((start = strchr(start, '=')) == NULL) {
    nferrormsg("zpx2zpn(): CTYPE2 keyword string is malformed!");
    *end = buf;
    return;
  }
  start += 1;
  if ((start = strstr(start, "-ZPX")) == NULL) {
    nferrormsg("zpx2zpn(): Axis 2 has different projection type than axis 1!");
    *end = buf;
    return;
  }
  start += 3;
  *start = 'N';
  *end = buf;

  /* Get projp1 and projp3 */
  if ((start = strstr(header, "WAT1_001")) == NULL)
    return;
  end = start + 80;
  buf = *end;
  *end = '\0';
  if ((nend = strchr(start, '/')) != NULL) {
    *end = buf;
    end = nend;
    buf = *end;
    *end = '\0';
  }
  if ((start = strchr(start, '=')) == NULL) {
    nferrormsg("zpx2zpn(): WAT1_001 keyword string is malformed!");
    *end = buf;
    return;
  }
  start += 1;
  if ((start = strstr(start, "projp1")) == NULL) {
    nferrormsg("zpx2zpn(): Couldn't find PROJP1 in WAT1_001!");
    *end = buf;
    return;
  }
  if ((start = strchr(start, '=')) == NULL) {
    nferrormsg("zpx2zpn(): WAT1_001 keyword string is malformed!");
    *end = buf;
    return;
  }
  start += 1;
  if (sscanf(start, "%f", &projp1) != 1) {
    nferrormsg("zpx2zpn(): Couldn't read PROJP1!");
    *end = buf;
    return;
  }
  if ((start = strstr(start, "projp3")) == NULL) {
    nferrormsg("zpx2zpn(): Couldn't find PROJP3 in WAT1_001!");
    *end = buf;
    return;
  }
  if ((start = strchr(start, '=')) == NULL) {
    nferrormsg("zpx2zpn(): WAT1_001 keyword string is malformed!");
    *end = buf;
    return;
  }
  start += 1;
  if (sscanf(start, "%f", &projp3) != 1) {
    nferrormsg("zpx2zpn(): Couldn't read PROJP3!");
    *end = buf;
    return;
  }
  *end = buf;

  /* Add the PROJP1 and PROJP3 keywords */
  len = strlen(header);
  i = 0;
  while (i < len && !isspace(header[i]))
    i += 80;
  if (i >= len) {
    nferrormsg("zpx2zpn(): No space in header!");
    return;
  }

  len = sprintf(header+i, "PROJP1  = %20.1f / Added by zpx2zpn()", projp1);
  start = header + i + len;
  *start = ' ';
  i += 80;
  len = sprintf(header+i, "PROJP3  = %20.1f / Added by zpx2zpn()", projp3);
  start = header + i + len;
  *start = ' ';

  return;
}
