# eris-telpicker
A utility for selecting suitable telluric stars for service mode observations with ERIS/IFS.

## Prerequisites
* numpy, scipy
* matplotlib
* astropy

## Input catalogues
xshooter-B-verified -- B-type stars filtered against Be-stars and binaries with XSHOOTER
xshooter-B -- B-type stars without XSHOOTER observations to check for emission lines/binarity
gaiaDR3-solar-analgoue -- G-type stars from the Gaia DR3 table gold\_sample\_solar\_analogues

## Additional filtering
The input catalogue of 8,524 stars is further filtered to exclude those with:
* RUWE >= 1.4 to exclude potential binary stars and/or large-amplitude variables,
* an entry in the Gaia DR3 Non-Single Star (NSS) catalogue,
* any Gaia DR3 source within 15" that has ΔGaia_RP < 2.5.
* Gaia RP <= 11 to allow for NGS AO when AO is needed to match science.

## Telluric star ranking
The utility by default ranks the telluric standards based on the minimum average airmass difference over the full range of hour angles that it is possible to start the science OB given its duration and airmass constraint. The metric optimized can be changed by modifying the `method` veriable to optimize based on the minimum or maximum airmass difference, or the standard deviation of the airmass difference.

It is also possible to select telluric standards to be observed before your science OB. To do this, change `after` to `False`.

## Usage
Put your target information in `target.txt` and run `python eris-telpicker.py`. In this table you must specify the:
* Target name
* Right Ascension (degrees)
* Declination (degrees)
* OB duration (minutes) -- the length of your science observation, including overheads
* AO mode [AO, noAO] -- whether you are using AO or not
* IFS plate scale -- which plate scale you are using (SPXW)
* IFS grating -- which grating you are using (SPGW)
* Maximum airmass of science OB -- the airmass constraint you used in P2
* Maximum airmass of telluric OB -- the maximum airmass you want to consider for the telluric star, typically this is the same as the airmass constraint used for the science OB.

For each entry in this file the script will generate a text file containing the best five telluric stars from the three samples described above, and a plot showing the difference in airmass between the target and the telluric standards as a function of the starting hour angle of the observation.

The output text file contains:
* Name -- Telluric standard name
* RA -- Right ascension (degrees)
* Dec -- Declination (degrees)
* Band -- Near-infrared band
* Mag -- Magnitude in the above band
* DIT -- Suggested DIT
* SNR -- SNR with this DIT from the ETC
* Max -- Maximum flux (e-) with this DIT from the ETC
* RP mag -- Gaia RP magnitude
* AO mode -- Suggested AO mode: NGS if science is an AO OB, noAO otherwise
* Min AM -- Minimum airmass difference between science and telluric over all possible hour angles
* Max AM -- Maximum airmass difference between science and telluric over all possible hour angles
* Avg AM -- Average airmass difference between science and telluric over all possible hour angles
* SD AM -- Standard deviation of the airmass difference between science and telluric over all possible hour angles
* Source -- Source of the telluric standard

