package org.eso.phase3.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import org.apache.log4j.Logger;
import org.eso.phase3.validator.ValidatorStat.StatType;

/**
 * This class should include the common part between ReleaseParserImp and ReleaseUpdateParserImp
 * 
 * @author vforchi
 *
 */
public abstract class AbstractReleaseParserWithExtraInfo implements	ReleaseParserWithExtraInfo {

    /** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(ReleaseParserWithExtraInfo.class);
    
	public static List<String> checkForRecursiveDatasets(Map<String, Set<String>> datasetMap, ValidatorStat stat) {
		List<String> errors = new ArrayList<String>();
		for (Entry<String, Set<String>> entry: datasetMap.entrySet()) {
			String mainFile = entry.getKey();
	   		/* check for recursive datasets */
	   		for (String dsFile: entry.getValue()) {
	   			if (!dsFile.equals(mainFile) && datasetMap.keySet().contains(dsFile)) {
	   				String msg = "File " + dsFile + " defines a nested dataset: this structure is not allowed"; 
	   	        	logger.error(msg);
	   	        	errors.add(msg);
	   	        	stat.add(StatType.ERROR_OTHER);
	   			}
	   		}
		}
		return errors;
	}
}
