package org.eso.phase3.validator;

/**
 * Interface of the wrapper around the external command line utility fits verify. 
 * @author dsforna
 */
public interface FitsVerifyExecutor
{
    /**
     * @return the error message of fits verify (i.e. what fits verify wrote on
     *         stdout). It is null if fits verify did not run yet.
     */
    public String getError();

    /**
     * @return the return code of fits verify (0: valid fits file, != 0 invalid
     *         fits file).
     */
    public int getExitStatus();

    /**
     * @return the pathname of the used external command line utility fits
     *         verify.
     */
    public String getFitsVerifyPathName();

    /**
     * @return the output of fits verify (i.e. what fits verify wrote on
     *         stdout). It is null if fits verify did not run yet.
     */
    public String getMessage();

    /**
     * @return the last component of the return of {@link #getFitsVerifyPathName}
     */
    public String getShortName();

    /**
     * @return Whether the fits verify executable is available or not.
     */
    public boolean isAvailable();
}
