/**
 * 
 */
package org.eso.phase3.validator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;

/**
 * Future replacement for HttpConf, when the OCA rules for extension headers 
 * will be supported. HttpConf Multiple Headers Interface.
 * @author dsforna
 *
 */
public interface HttpConfMHI
{
    /**
     * This class is defined within the interface because its instances are 
     * closely binded to the interface's methods. 
     * @author dsforna
     *
     */
    public static class OcaRulesKey
    {
        /** 
         * Offset from the primary header of the header for which the rules 
         * associated to this OcaRulesKey are parsed.
         */
        public final int offset;
        
        /**
         * List of values associated to a the fits file for which 
         * the rules of this OcaRulesKey are parsed. 
         */
        private String[] values;
        
        /**
         * List of keywords associated with values 
         */
        private String[] keywords;
        
        @Override
        public String toString()
        {
            return Arrays.toString(keywords) + ":" + Arrays.toString(values);
        }
        
        private String associateOcaRuleFile = null;
        /**
         * @return the associateOcaRuleFile
         */
        public String getAssociateOcaRuleFile()
        {
            return associateOcaRuleFile;
        }
        
        /** @param associateOcaRuleFile the associateOcaRuleFile to set.*/
        public void setAssociateOcaRuleFile(String associateOcaRuleFile)
        {
            if (associateOcaRuleFile != null)
            {
                if (associateOcaRuleFile.equals("")) {associateOcaRuleFile = null;}
            }
            this.associateOcaRuleFile = associateOcaRuleFile;
        }

        /**Build a key for the given keywords/values,offset. 
         * @param category
         * @param offset
         */
        public OcaRulesKey(String[] keywords, String[] values, int offset)
        {
            if (keywords == null)
            {
                throw new IllegalArgumentException(
                        "Null input argument: keywords");
            }
            else if (values == null)
            {
                throw new IllegalArgumentException(
                "Null input argument: values");
            }
            else if (keywords.length != values.length)
            {
                throw new IllegalArgumentException(
                "different lengthst for keywords,values");
            }
            else 
            {
                this.keywords = new String[keywords.length];
                System.arraycopy(keywords, 0, this.keywords, 0, keywords.length );
                this.values = new String[values.length];
                System.arraycopy(values, 0, this.values, 0, values.length );
                this.offset = offset;
            }
        }
    }
    
    public static final String CATG_LIST_FILE = null;
    public static final String CATG_OCA_FILE = Consts.CATG_OCA_FILE;

    /**
     * Retrieves the OCA rules to validate a FITS file of the input OcaRulesKey.
     * 
     * @param ocaRulesFileName
     *            the OCA rules filename from which to retrieve the OCA rules
     * @return the InputStream where the rules can be read from.
     * @throws IOException
     */
    public InputStream getFileStream(String ocaRulesFileName) throws IOException;

    /**
     * Check that a stream to read the OCA rules is available for the input
     * category.
     * 
     * @param ocaRulesKey
     *            the OcaRulesKey of the requested OCA rules.
     * @return available true if there are OCA rules.
     */
    public boolean hasRules(OcaRulesKey ocaRulesKey);
        
    /**
     * Check if the input category was listed in the category list file.
     * 
     * @param catg
     * @return true if the category catg was listed.
     */
    public boolean isValid(String catg);

    
    /**Return the selection rules filename for the input category.
     * @param filename
     * @return
     */
    public String getSelectionRulesFileName(String filename);
    
    /**
     * @return the map (category, selectionRulesFile)
     * @throws IOException
     *             if CATG_LIST_FILE not found or it is found but there was an
     *             error while parsing.
     */
    public Map<String, String> getDeclaredCategories() throws IOException;

}
