package org.eso.phase3.validator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eso.oca.fits.OCAFile;
import org.eso.oca.parser.ASTStart;
import org.eso.oca.parser.OcaParser;

public class HttpConfMultipleHeadersImpl implements HttpConfMHI {

    /** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(HttpConfMultipleHeadersImpl.class);

    /**File CATG_OCA and OCA rule files must be found at this URL.*/
    private final String ocaBaseUrl;
    
    /**Each OCA rules file is read once through HTTP and its content is stored here.*/
    private final Map<String, byte[]> cachedOcaRules = new HashMap<String, byte[]>();
    
    private ASTStart selectionRules;
	
    public HttpConfMultipleHeadersImpl(final String ocaBaseUrl) throws Exception
    {
        this.ocaBaseUrl = ocaBaseUrl;
        parseSelectionRules();
    }

    private void parseSelectionRules() throws Exception {
   		String urlString = ocaBaseUrl + "/" + HttpConfMHI.CATG_OCA_FILE;
   		URL u = new URL(urlString);

   		InputStreamReader is = new InputStreamReader(u.openStream());
   		selectionRules = new OcaParser(is).Start();
    }


	@Override
	public Map<String, String> getDeclaredCategories() throws IOException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getFileStream(String ocaRulesFileName) throws IOException {
        if (ocaRulesFileName == null) {
            logger.error("Null input argument: ocaRulesFileName");
            throw new IllegalArgumentException("Null input argument: ocaRulesFileName");
        }

        if (!cachedOcaRules.containsKey(ocaRulesFileName)) {
            logger.debug("Reading and caching OCA rules for " + ocaRulesFileName);
            URL u = new URL(ocaBaseUrl + "/" + ocaRulesFileName);
       		InputStreamReader isr = new InputStreamReader(u.openStream());
       	    cachedOcaRules.put(ocaRulesFileName, IOUtils.toByteArray(isr));
        }
        return new ByteArrayInputStream(cachedOcaRules.get(ocaRulesFileName));
	}

	@Override
	public String getSelectionRulesFileName(String filename) {
		return HttpConfMHI.CATG_OCA_FILE;
	}

	@Override
	public boolean hasRules(OcaRulesKey ocaRulesKey) {
        if (ocaRulesKey == null)
        {
            logger.error("Null input argument: ocaRulesKey");
            throw new IllegalArgumentException("Null input argument: ocaRulesKey");
        }

        if (ocaRulesKey.getAssociateOcaRuleFile() != null)
        {
            return true;
        }
        else
        {
            logger.debug("No rules defined [" + ocaRulesKey.toString() + "]");
            return false;
        }
	}

	@Override
	public boolean isValid(String catg) {
		Hashtable table = new Hashtable();
		table.put(Consts.CATG_KW, catg);
		table.put(Consts.EXTNUM, BigInteger.valueOf(-1L));
		table.put(OCAFile.FILENAME, "");
		OCAFile f = new OCAFile(table);
		
		try {
			selectionRules.classify(new OCAFile[]{f});
			return f.getKeywordValue(Consts.RESULT_METAKEYWORD).equals("true");
		} catch (Exception e) {
			logger.error(e.getMessage());
			return false;
		}
	}

}
