/**
 * 
 */
package org.eso.phase3.validator;

import org.apache.log4j.Logger;

/**
 * Implement the null object pattern, twice (for a valid step and one for an
 * invalid step).
 * 
 * @author dsforna
 * 
 */
public class NullValidator implements ValidationStep
{
    public static final ValidationStep invalidStep;

    public static final ValidationStep validStep;

    /** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(NullValidator.class);

    static
    {
        validStep = new NullValidator(true);
        invalidStep = new NullValidator(false);
    }

    private final boolean valid;

    private NullValidator(final boolean valid)
    {
        this.valid = valid;
    }

    @Override
    public String toString()
    {
        if (valid) { return "NullValidator (valid)"; }
        else {return "NullValidator (invalid)"; }
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see org.eso.phase3.validator.ValidationStep#isValid()
     */
    @Override
    public boolean isValid()
    {
        final String methodName = "NullValidator::isValid";
        logger.trace(methodName);
        if (!valid) { logger.debug("This null validation is in status failed ." );}
        return valid;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eso.phase3.validator.ValidationStep#runValidation()
     */
    @Override
    public void runValidation()
    {
        final String methodName = "NullValidator::runValidation";
        logger.trace(methodName);
        logger.debug("runValidation called on a null validation.");
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eso.phase3.validator.ValidationStep#validationReport()
     */
    @Override
    public synchronized ValidationReport validationReport()
    {
        final String methodName = "NullValidator::validationReport";
        logger.trace(methodName);
        return new ValidationReport("Null validation", null);
    }
}
