package org.eso.phase3.validator;

/**
 * A class for a "data transfer" object which holds together all the different
 * names of a configuration option, and the extra information used to build the
 * corresponding command line option (argument flag and description). Note that
 * once constructed the object is immutable, therefore instead of getter methods
 * the attribute themselves are declared public.
 * 
 * @author dsforna
 */
public class OptionNames
{
    /** Command line description of this option. */
    public final String description;

    /** Whether this option has arguments when set from command line. */
    public final boolean hasArg;

    /**
     * Command line long name of the option. If it is null this option cannot be
     * set from command line.
     */
    public final String longCli;

    /** The main name of an option. It cannot be null. */
    public final String name;

    /**
     * Command line short name option. It can be null, but at the same time this
     * option can still be set from command line if the log name is not null.
     */
    public final String shortCli;
    
    public final String defaultValue;

    public OptionNames(final String name, final String longCli,
            final String shortCli, final boolean hasArg,
            final String description, final String defaultValue)
    {
        if (name == null)
        {
            throw new IllegalArgumentException("Null input argument: name");
        }
        this.name = name;
        this.longCli = longCli;
        this.shortCli = shortCli;
        this.hasArg = hasArg;
        this.description = description;
        this.defaultValue = defaultValue;
    }
}
