package org.eso.phase3.validator;

/**
 * The step of the validation process performed on a {@link ValidatorFile}. 
 * If this step runs, its report contains all the information about the run and 
 * the method isValid return true only if the report's status is not error.  
 * @author dsforna
 * 
 */
public interface ValidationStep
{
    /**
     * @return If this validation step was successful (true/false).
     */
    public boolean isValid();

    /**
     * Runs the validation step.
     */
    public void runValidation();

    /**
     * @return The {@link ValidationReport} associated to this validation step.
     */
    public ValidationReport validationReport();
}
