package org.eso.phase3.validator;

/**
 * The configuration values come from: <li>Internal configuration file (resource
 * INTERNAL_CONF_FILE).</li> <li>Command line input</li> <li>System Properties
 * (optional).</li> The recognized System properties are: <li>
 * INTERNAL_RUN_CONF_NAME: If the run is internal at ESO or at a remote
 * location.</li> <li>MOCKUP_FILE_CONF_NAME: pathname of a file defining the
 * mapping between real and mockup objects (only for testing). The mapping is
 * used by the {@link ValidatorFactory}.</li>
 * 
 * @author dsforna
 * 
 */
public interface ValidatorConfiguration
{

    public static final String APPLICATION_COMMAND = "application.command";

    // Only as default meta-configuration in the internal configuration file:
    public static final String APPLICATION_NAME = "application.name";

    public static final String APPLICATION_VERSION = "application.version";
    
    public static final OptionNames SHOW = new OptionNames("show", "show",
            null, false, "Print configuration and exit.", null);

    public static final OptionNames HELP = new OptionNames("help", "help", "h",
            false, "Print help page and exit.", null);

    public static final OptionNames VERBOSE_MODE = new OptionNames(
            "validator.verbose.mode", "verbose", "V", false,
            "Set the log level in the log file to debug.", null);
    
    public static final OptionNames RELEASE_DIR = new OptionNames(
            "validator.release.dir", "reldir", "r", true,
            "Mandatory option: set the release directory (<arg> is the directory path)", null);

    public static final OptionNames URL = new OptionNames("validator.conf.url",
            "url", "u", true, 
            "Set base URL of the metadata rules files. Examples:" 
            + " -u http://www.eso.org/edp/phase3-metarules ,"
            + " -u file:///home/edp/new-metarules", null);

    public static final OptionNames VERSION = new OptionNames("version",
            "version", "v", false, "Print version and exit.", null);

    public static final OptionNames CONF_FILE_PATH = new OptionNames(
            "validator.configuration.file.path", "conf", "c", true,
            "Set command line option values from an input configuration file (<arg> is the configuration file pathname).", null);

    public static final OptionNames FITSVERIFY = new OptionNames(
            "validator.fitsverify", "fitsverify", "f", true,
            "Set name and path to the fits verify utility to use (<arg> is this pathname).", "NONE");

    public static final OptionNames THREADS = new OptionNames(
            "validator.threads.number", "threads", "t", true, 
            "Set the number of threads of execution (0 for dynamically chosen).", null);

    public static final OptionNames MODIFICATION_TYPE = new OptionNames(
            "release.modification.type", "modification-type", "m", true,
            "Mandatory option: specifiy if this is a new release or an updating of an existing release (<arg> is one of the strings: "
            +ValidatorConfiguration.MODIFICATION_TYPE_VALUE_NEW + " , " 
            + ValidatorConfiguration.MODIFICATION_TYPE_VALUE_UPDATE + ")", null);

    /*
     * The following configuration options are not modifiable from command line
     * arguments, they can be set as system properties or as default
     * configuration in the internal configuration file (or programmatically
     * after construction).
     */
    
    /** Not modifiable from command line option but with a system property.*/
    public static final String INTERNAL_RUN_CONF_NAME = "validator.at.eso";

    /** Not modifiable from command line option but with a system property.*/
    public static final String MOCKUP_FILE_CONF_NAME = "validator.mockup.file";

    /** Not modifiable from command line option but with a system property.*/
    public static final String ACCEPT_LEADING_0_IN_KEYWORD_INDEXES_NAME = "validator.accept.leading.0";

    /** Not modifiable from command line option but with a system property.*/
    public static final String ENABLE_HDR_FILES = "validator.enable.hdr.files";
    
    /**
     * Modification type option will be set to one of this value from the input
     * value. If one value cannot be chosen from the input, it will be an error.
     */
    public static final String MODIFICATION_TYPE_VALUE_UPDATE = "update";
    public static final String MODIFICATION_TYPE_VALUE_NEW = "create";

    /** An explicit 'not true', but anything different from 'T' would do */
    public static final String OPTION_FALSE = "F";

    /**
     * Value assigned (and returned by {@link#getOptionValue}) when an option is
     * "true". The {@link#isTrue} method will also return true.
     */
    public static final String OPTION_TRUE = "T";


    /**
     * The resource name for the internal configuration file. It is read as
     * classpath resource (therefore the leading slash).
     */
    public static final String INTERNAL_CONF_FILE = "/validator.properties";

    
    /**
     * Get the configured value for the input option. If option is not
     * configured, the empty string is returned. A null input option results in
     * an IllegalArgumentException being thrown.
     * 
     * @param option
     *            the configuration option.
     * @return the value corresponding to the input option.
     */
    public String getOptionValue(String option);

    /**
     * The configuration values are all string. This method determines which
     * string values are equivalent to the true boolean value. The details of
     * the match depends on the implementation.
     * 
     * @param option
     *            the configuration option whose value is evaluated.
     * @return the boolean equivalent of the value of the input option.
     */
    public boolean isTrue(String option);
        
    /**
     * Programmatically set the value of the input configuration option.
     * 
     * @param optionName
     *            the name of the configuration option being set
     * @param optionValue
     *            the value of the configuration option
     * @throws ValidatorException
     *             if the changed configuration is no longer valid.
     */
    public void setOptionValue(String optionName, String optionValue)
            throws ValidatorException;

}
