package org.eso.phase3.validator;

/**
 * The class implementing this interfaces take cares of performing the
 * configured validation steps and storing their results.
 * 
 * @author dsforna
 * 
 */
public interface ValidatorManager
{

    /**
     * @return The messages of the error(s) found during this validation as
     *         single strings. If there are no errors an empty string is
     *         returned.
     */
    public String getErrors();

    /**
     * @return the complete text associated with the last release validation in
     *         form of a {@link ValidationReport} object.
     */
    public ValidationReport getReport();

    /**
     * Put the parsed structure of the release in a tabular format and return it
     * in a string.
     * 
     * @return the string.
     */
    public String reportTable();

    /**
     * @return high level statistic on the last release validation (number of
     *         valid/invalid files, datasets, and so on).
     */
    public String statistic();

    /**
     * Validate this release and return a global pass/fail result.
     * 
     * @return the result of validation.
     */
    public boolean validateRelease(boolean internal);

}
