package org.eso.phase3.validator;

import java.io.IOException;
import java.util.Map;

import org.eso.oca.fits.KeywordNotFoundException;
import org.eso.oca.fits.UndefinedValueException;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.ParseException;

/**
 * @author dsforna
 * 
 */
public interface ValidatorOcaParser
{

    public boolean hasRulesFile();
    
    public String getRulesFilename();

    /**
     * Get the classification meta-keywords, which basically say if the fits
     * file is valid or not.
     * 
     * @return
     * @throws IOException
     * @throws ParseException
     * @throws InterpretationException
     * @throws KeywordNotFoundException
     * @throws UndefinedValueException
     */
    public Map<String, String> getClassification(boolean internal) throws IOException,
            ParseException, InterpretationException, KeywordNotFoundException,
            UndefinedValueException, ValidatorException;

    /**
     * @return the error message associated when {@link #isValid()} returns
     *         false.
     */
    public String getErrorMsg();

    /**
     * @return if the object implementing this interface has been successfully
     *         constructed.
     */
    public boolean isValid();

}