/**
 * 
 */
package org.eso.phase3.validator;

import java.io.File;

import org.eso.oca.fits.DataTransportFormatHandler;


/**
 * @author dsforna
 * 
 */
public interface ValidatorSetup
{
    
    /**
     * @param f File to validate 
     * @param category category of the file
     * @param inError if the step is already in error before performing the validation.
     * @return 
     */
    public ValidationStep createValidationStep(File f, String category, boolean inError, boolean internal);
    

    /**Create the object managing the actual execution of the validation steps.
     * The execution of the steps can be configured to be single-thread or multi-thread.
     * @param incFileDisk
     * @return
     */
    public ValidationStepRunnerManager createStepRunnerManager(double incFileDisk);
    
    /**
     * Method instantiating the objects in this application which implements
     * {@link FitsVerifyExecutor}.
     * 
     * @param fitsFileFullPathName
     * @return the instantiated object.
     * @throws ValidatorException
     */
    public FitsVerifyExecutor createFitsVerifyExecutor(
            String fitsFileFullPathName) throws ValidatorException;

    
    /**
     * Create a new OCA parser for parsing a header with an index different from 
     * the primary header index.
     * 
     * @param fileFullPathName
     *            fits file to parse.
     * @param extCategory
     *            category of the fits extension to parse.
     * @param headerIndex
     *            index of the header to parse.
     * @param offset
     *            offset from the primary header of the header with index headerIndex. 
     * @return the OCA file parser.
     * @throws ValidatorException
     */
    public ValidatorOcaParser createValidatorOcaParser(String fileFullPathName,
            String extCategory, DataTransportFormatHandler fh, int headerIndex, int offset) throws ValidatorException;


    public ArchivedFilesClient getArchivedFilesClient();

    public ValidatorConfiguration getConfiguration();

    public HttpConfMHI getHttpConf();

    public ProgressBar getProgressBar();

    public ReleaseParserWithExtraInfo getReleaseParser();

    public ValidatorManager getValidatorManager();

    public ValidatorStat getValidatorStat();
    
    /**
     * @return if the release of this run is a new release (and not an update release).
     */
    public boolean isNewRelease();

}