/**
 * 
 */
package org.eso.phase3.validator.catalog;

import org.apache.log4j.Logger;

import org.eso.oca.fits.DataTransportFormatHandler;
import org.eso.oca.fits.FileHandlerException;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.TypedHeaderCardException;
import org.eso.phase3.validator.Consts;
import org.eso.phase3.validator.ValidationUtil;

/**
 * Extract the values of the keywords declared in Consts.KeywordForRowcount from 
 * this catalog fits file.
 * @author dsforna
 *
 */
public class CatalogDimensionExtractor
{
    /** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(CatalogDimensionExtractor.class);
    private Long rowcount = null;
    private Long naxis2 = null;
    private DataTransportFormatHandler dtfh = null;
    
    public CatalogDimensionExtractor(String filePathName, int indexPH) throws Exception
    {
        if (filePathName == null)
        {
            logger.error("Null input argument: filePathName");
            throw new IllegalArgumentException(
                    "Null input argument: filePathName");
        }
        
        TypedHeaderCard[] cards = null;    
        try
        {
            dtfh  = ValidationUtil.allocateDTFH(filePathName);
            if (dtfh.getNumberOfHDUs() < 2)
            	throw new Exception("Missing extension");
            
           int idxExtensionHeader = indexPH + 1;
    		
            String keyword = "";//Consts.KeywordForRowcount.ROWCOUNT.toString();
            cards = dtfh.getFITSCards(idxExtensionHeader, new String[] {keyword});
            if (cards.length == 1)
            {
            	if (cards[0].isUndefined())
            		rowcount = null;
            	else { 
            		String value = cards[0].getValue();
            		logger.debug("Extracting as number the value of " 
            			+ keyword + " = " + value);
            		rowcount = Long.parseLong(value);
            	}
            }
            else 
            {
                logger.debug("Keyword not present: "+ keyword);
            }
            
            keyword = "";//Consts.KeywordForRowcount.NAXIS2.toString();
            cards = dtfh.getFITSCards(idxExtensionHeader, new String[] {keyword});
            if (cards.length == 1)
            {
            	if (cards[0].isUndefined())
            		naxis2 = null;
            	else { 
            		String value = cards[0].getValue();
            		logger.debug("Extracting as number the value of " 
            				+ keyword + " = " + value);
            		naxis2 = Long.parseLong(value);
            	}
            }
            else 
            {
                logger.debug("Keyword not present: "+ keyword);
            }
        }
        catch( FileHandlerException e )
        {
            logger.error(e.getMessage());
        }
        catch( TypedHeaderCardException e )
        {
            logger.error(e.getMessage());
        }
        catch(NumberFormatException e)
        {
            logger.error(e.getMessage());
        }
        finally 
        {
            dtfh = null;
        }
    }
    
    public Long extractRowcount()
    {
        return rowcount;
    }
    
    public Long extractNaxis2()
    {
        return naxis2;
    }
}
