package org.eso.phase3.validator.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.phase3.validator.ValidationReport;
import org.eso.phase3.validator.ValidatorStat;
import org.eso.phase3.validator.ValidationReport.STATUS;
import org.eso.phase3.validator.ValidatorStat.StatType;

public class IndexedKeywordValidator {
	
	/** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(IndexedKeywordValidator.class);
	
	protected static Map<String, String> previousValues = Collections.synchronizedMap(new HashMap<String, String>());
	
    protected List<TypedHeaderCard> cards = new ArrayList<TypedHeaderCard>();

    protected static int totalFields;
    protected ValidationReport report;
    protected ValidatorStat stat;
    protected String fileName;
    
	public IndexedKeywordValidator(int tFields, ValidationReport report, ValidatorStat stat, String fileName) {
		totalFields = tFields;
		this.report = report;
		this.stat = stat;
		this.fileName = fileName;
	}
    
    public void add(TypedHeaderCard card) {
    	String previousValue = previousValues.get(card.getKey());
    	if (previousValue != null && !previousValue.equals(card.getValue())) {
			String msg = "[" + fileName + "] - keyword " + card.getKey() + " already present in another file with a different value: current " +
					card.getValue() + ", previous " + previousValue;
			logger.error(msg);
			report.attemptStatus(STATUS.ERROR, msg);
			stat.add(StatType.ERROR_CATALOG_VALIDATION);
    	} else {
    		previousValues.put(card.getKey(), card.getValue());
    	}
    	cards.add(card);
    }
    
	public void process() {
		   
	}
	
	/* reset needed in case of multiple validations */
	public static void reset() {
		previousValues.clear();
	}
}