package org.eso.phase3.validator.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.phase3.validator.ValidationReport;
import org.eso.phase3.validator.ValidatorStat;
import org.eso.phase3.validator.ValidationReport.STATUS;
import org.eso.phase3.validator.ValidatorStat.StatType;

public class IndexedKeywordsValidator {
	
	/** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(IndexedKeywordsValidator.class);
    
    private static Pattern indexedPattern = Pattern.compile("([A-Z]+)([1-9]\\d*)");
    
    private Map<String, IndexedKeywordValidator> validators = new HashMap<String, IndexedKeywordValidator>();
    
    private String fileName;
    private int tFields;
    private ValidationReport report;
    private ValidatorStat stat;
//	private String resourcesUrl;
	
    public IndexedKeywordsValidator(String fileName, int tFields, ValidationReport report, ValidatorStat stat) {
    	this.fileName = fileName;
    	this.tFields = tFields;
    	this.report = report;
    	this.stat = stat;
//    	this.resourcesUrl = url;
    	init();
    }
    	
    private void init() {
    	validators.clear();
    	validators.put(TFormNKwdValidator.kwIdentifier, new TFormNKwdValidator(tFields, report, stat, fileName));
    	validators.put(TTypeNKwdValidator.kwIdentifier, new TTypeNKwdValidator(tFields, report, stat, fileName));
    	validators.put(TUcdNKwdValidator.kwIdentifier, new TUcdNKwdValidator(tFields, report, stat, fileName));
    	validators.put(TCommNKwdValidator.kwIdentifier, new TCommNKwdValidator(tFields, report, stat, fileName));
    	validators.put(TScalNKwdValidator.kwIdentifier, new TScalNKwdValidator(tFields, report, stat, fileName));
    	validators.put(TZeroNKwdValidator.kwIdentifier, new TZeroNKwdValidator(tFields, report, stat, fileName));
    	validators.put(TXLinkKwdValidator.kwIdentifier, new TXLinkKwdValidator(tFields, report, stat, fileName));
    	validators.put("TDMIN", new IndexedKeywordValidator(tFields, report, stat, fileName));
    	validators.put("TDMAX", new IndexedKeywordValidator(tFields, report, stat, fileName));
    	validators.put("TXP3C", new IndexedKeywordValidator(tFields, report, stat, fileName));
    	validators.put("TXP3R", new IndexedKeywordValidator(tFields, report, stat, fileName));
    	validators.put("TXCTY", new IndexedKeywordValidator(tFields, report, stat, fileName));
    }
	
    public void add(TypedHeaderCard card) {
    	String key = card.getKey();
    	String root;
    	Matcher m = indexedPattern.matcher(key);
    	if (m.matches()) {
    		root = m.group(1);
    		int index = Integer.valueOf(m.group(2));
    		IndexedKeywordValidator val = validators.get(root);
    		if (val != null) {
    			if (index > tFields) {
        			String msg = "[" + fileName + "] - keyword " + card.getKey() + " refers to a column bigger than TFIELDS ";
    				logger.error(msg);
        			report.attemptStatus(STATUS.ERROR, msg);
        			stat.add(StatType.ERROR_CATALOG_VALIDATION);
        		} else {
        			val.add(card);
        		}
    		}
    	}
    }
    
    public void process() {
		for (IndexedKeywordValidator validator: validators.values()) 
			validator.process();
    }
    
    /* reset needed in case of multiple validations */
	public static void reset() {
    	IndexedKeywordValidator.reset();
    }
         
}