package org.eso.phase3.validator.catalog;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.phase3.validator.ValidationReport;
import org.eso.phase3.validator.ValidationUtil;
import org.eso.phase3.validator.ValidatorStat;
import org.eso.phase3.validator.ValidationReport.STATUS;
import org.eso.phase3.validator.ValidatorStat.StatType;

public class ListIndexedKeywordValidator extends IndexedKeywordValidator {

	/** Apache Log4J logger for this class namespace. */
	private static final Logger logger = Logger.getLogger(ListIndexedKeywordValidator.class);

	private static Map<String, Set<String>> cachedAllowedValues = new HashMap<String, Set<String>>();
	
	private Set<String> allowedValues;
	
	public ListIndexedKeywordValidator(int tFields, String resource, ValidationReport report, ValidatorStat stat) {
		super(tFields, report, stat, null);
	}

	@Override
	public void process() {
		for (TypedHeaderCard card: cards) {
			if (!allowedValues.contains(card.getValue())) {
				String msg = "Invalid value component (" + card.getValue() + ") - keyword:" + card.getKey();
				logger.error(msg);
				report.attemptStatus(STATUS.ERROR, msg);
				stat.add(StatType.ERROR_CATALOG_VALIDATION);
			}
		}
	}

	public Set<String> fetchList(String resource) {
		if (!cachedAllowedValues.containsKey(resource)) {
			try {
				cachedAllowedValues.put(resource, ValidationUtil.readAsSet(new URL(resource).openStream()));
			} catch (Exception e) {
				throw new RuntimeException("Cannot read from resource: " + resource);
			}
		}
		return cachedAllowedValues.get(resource);

	}
}
